# Fair Clustering in the Sliding Window Model
This is the research code for the paper "Fair Clustering in the Sliding Window Model" that has been accepted by ICLR 2025.
This research code consists of the full implementation of all experiments mentioned in the paper, and can be used to reproduce the experiments results.


Our proposed algorithm is implemented in Java and Python. Apart from our algorithm, we also include a Python implementation of FairTree: https://github.com/sfjiang1990/Coresets-for-Clustering-with-Fairness-Constraints, and a C++ implementation for Borassi algorithm using the Borassi library: https://github.com/google-research/google-research/tree/master/sliding_window_clustering/ (which is one of our baseline).


Our implementation relies on the following Java libraries which we do not include in this repo:

Apache Common CSV 1.7: http://commons.apache.org/proper/commons-csv/

Apache Common Math 3.6: https://commons.apache.org/proper/commons-math/

JSON.simple: https://code.google.com/archive/p/json-simple/

Please put relevant jar/dll/so files into /lib folder.


To run the experiments, one also needs to:

1. Prepare the Java and Python environments.

2. Prepare the gurobipy library.

3. Download the following datasets and compress the CSV files as data.csv.gz files and put them in data/DATASET_NAME/ folder. For instance, for Adult, one should compress & put it in data/Adult/data.csv.gz.

Adult: https://archive.ics.uci.edu/ml/datasets/Adult

Athlete: https://www.kaggle.com/heesoo37/120-years-of-olympic-history-athletes-and-results

Bank: https://archive.ics.uci.edu/ml/datasets/bank+marketing

Diabetes: https://archive.ics.uci.edu/ml/datasets/diabetes

Census: https://archive.ics.uci.edu/ml/datasets/US+Census+Data+(1990)


One can first generate the centers computed by the Borassi algorithm (a file containing the centers found by the Borassi) as described in Borassi2020/README.md, and then call the main method in fair_clustering/src/Main.java to run our algorithm and all the baselines.
