 
import sys
import numpy as np
from collections import defaultdict
import time
import math
from random import sample
from linear_programming import linear_programming_slove_cost_wt, linear_programming_slove_cost

class Point:
    def __init__(self, coordinates, timestamp, color, weight=1):
        self.coordinates = coordinates  # Coordinates of points.
        self.timestamp = timestamp  
        self.weight = weight
        self.color = color

    def __getitem__(self, index):
        return self.coordinates[index]

    def __repr__(self):
        return f"Point(coords={self.coordinates}, time={self.timestamp})"
    
    def to_dict(self):
        return {
            "coordinates": self.coordinates,
            "timestamp": self.timestamp,
            "weight": self.weight,
            "color": self.color
        }



def read_coordinates_from_file(file_path):
    centers = []

    with open(file_path, 'r') as file:
        for line in file:
            line = line.strip()
            coordinate_strs = line.split(',')
            coordinates = []

            for coord_str in coordinate_strs:
                coords = [float(x) for x in coord_str.split()]
                coordinates.append(coords)

            centers.append(coordinates)

    return centers



def Borassi_cost(p, q, k, compare_coreset, input_center_filename, ith):
    """
    Perform clustering using Borassi2020.

    Parameters:
    ----------
    p : int
        Balancing parameter.
        
    q : int
        Balancing parameter.
        
    k : int
        Number of clusters to create.
        
    compare_coreset : [Point]
        A large coreset of the sliding window for comparison and clustering.
        
    input_center_filename : str
        File containing the cluster centers.
        
    ith : int
        The index of the current sliding window.

    Returns:
    -------
    kmedian_cost : int
        The cost of clustering.
    """

    # coordinates_compare, color_compare, weight_compare
    try:
        p = min(p, q)
        q = max(p, q)
    except:
        print("First two parameters must be non-negative integers that specify the target balance; terminating")
        sys.exit(0)

    centers = read_coordinates_from_file(input_center_filename)
    center = centers[ith]

    coordinates_compare = [point.coordinates for point in compare_coreset]
    color_compare = [point.color for point in compare_coreset]
    weight_compare = [point.weight for point in compare_coreset]

    kmedian_cost = linear_programming_slove_cost_wt(coordinates_compare, color_compare, weight_compare, center, p, q)
    # kmedian_cost = linear_programming_slove_cost(coordinates_compare, color_compare, centers[ith], p, q)
    return kmedian_cost



