import os
import tempfile

import neptune.new as neptune
import omegaconf

# RUN_ID = "memento-6278"

### get memento cvrp checkpoint
# RUN_ID = "memento-9203"
# RUN_ID = "memento-9982"
# RUN_ID = "memento-10071"
# RUN_ID = "memento-10036"
# RUN_ID = "memento-10238"
# RUN_ID = "memento-10276"  # this is the POMO TSP500 checkpoint
# RUN_ID = "memento-10319"  # this is the MEMENTO TSP500 checkpoint
# RUN_ID = "memento-10714"  # this is the MEMENTO TSP500 checkpoint
RUN_ID = "memento-10240"  # MEMENTO TSP100


PROJECT_NAME = "PROJECT-NAME"
API_TOKEN = "eyJhcGlfYWRkcmVzcyI6Imh0dHBzOi8vYXBwLm5lcHR1bmUuYWkiLCJhcGlfdXJsIjoiaHR0cHM6Ly9hcHAubmVwdHVuZS5haSIsImFwaV9rZXkiOiI2MmExNmMyNC0wMjMyLTRiYjgtOTU5YS1jMTY0Zjg1MDAyOTcifQ=="

if __name__ == "__main__":
    # init the run
    # run = neptune.init_run(
    run = neptune.init(
        project=PROJECT_NAME,
        with_id=RUN_ID,
        api_token=API_TOKEN,
    )

    # create a temporary directory to store the config file
    with tempfile.TemporaryDirectory() as tmpdir:
        # download the config file
        run["config"].download(tmpdir)

        # load the config file
        cfg = omegaconf.OmegaConf.load(tmpdir + "/config.yaml")

    # define destination directory
    destination_dir = cfg.checkpointing.directory

    print(destination_dir)
    # create the direcroty if it does not exist
    if not os.path.exists(destination_dir):
        os.makedirs(destination_dir)
    else:
        # raise Error
        raise ValueError(f"Directory {destination_dir} already exists.")

    # define destination path
    destination_path = cfg.checkpointing.directory  # + "checkpoint.pkl"

    # get the checkpoint and save it
    run["checkpoint"].download(destination_path)

    # save the config in the same directory
    omegaconf.OmegaConf.save(cfg, destination_path + "config.yaml")

    # stop the run
    run.stop()
