#!/bin/bash

{
# run a training - cvrp100
#python experiments/train.py --config-name config_exp_cvrp environment.num_nodes=100

# then run fast rl evaluations
# # 10000 instances of size 100 (loaded)
# python experiments/validate.py --config-name config_exp_cvrp validation.batch_size=5 validation.problems.load_problem=True validation.problems.load_path="data/validation/vrp100_test_seed1234.pkl" validation.problems.num_problems=10000 validation.environment.num_nodes=100 validation.environment.norm_factor=50
# 1000 instances of size 125 (loaded)
python experiments/validate.py --config-name config_exp_cvrp validation.batch_size=25 validation.problems.load_problem=True validation.problems.load_path="data/validation/vrp125_test_small_seed1235.pkl" validation.problems.num_problems=1000 validation.environment.num_nodes=125 validation.environment.norm_factor=55
# 1000 instances of size 125 (loaded)
python experiments/validate.py --config-name config_exp_cvrp validation.batch_size=5 validation.problems.load_problem=True validation.problems.load_path="data/validation/vrp150_test_small_seed1235.pkl" validation.problems.num_problems=1000 validation.environment.num_nodes=150 validation.environment.norm_factor=60


# run slow rl eval - with loaded instances
# 10000 instances of size 100 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp100_test_seed1234.pkl" slowrl.problems.num_problems=10000 slowrl.environment.num_nodes=100 slowrl.environment.norm_factor=50
# 1000 instances of size 125 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=25 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp125_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_nodes=125 slowrl.environment.norm_factor=55
# 1000 instances of size 150 (loaded)
python experiments/slowrl_validate.py --config-name config_exp_cvrp slowrl.batch_size=5 slowrl.problems.load_problem=True slowrl.problems.load_path="data/validation/vrp150_test_small_seed1235.pkl" slowrl.problems.num_problems=1000 slowrl.environment.num_nodes=150 slowrl.environment.norm_factor=60

}
