#################################
#
# Constants.
#
#################################


from enum import Enum

class EXAMPLE_TAG(Enum):
    CONTROL = 0
    EXPERIMENT = 1

OPENAI_RATE_LIMIT = 10
PRICING_DOLLAR_PER_1M_TOKEN = {
    "gpt-4o-mini-2024-07-18": {"input": 0.150, "output": 0.600},
    "gpt-4o-mini": {"input": 0.150, "output": 0.600},
    "gpt-4o": {"input": 5.00, "output": 15.00},
}

UNIT_1M = 1_000_000

CHAT_MODELS = {
    "google/gemma-2-2b-it",
    "google/gemma-2-9b-it",
    "google/gemma-3-12b-it",
    "google/gemma-3-27b-it",
    "meta-llama/Llama-3.1-8B-Instruct",
}

BASE_MODELS = {
    "google/gemma-2-2b", 
    "meta-llama/Llama-3.1-8B"
}

HAS_SYSTEM_PROMPT_MODELS = {
    "meta-llama/Llama-3.1-8B-Instruct",
    "google/gemma-3-12b-it",
    "google/gemma-3-27b-it",
    "google/gemma-3-12b-it",
}

EMPTY_CONCEPT = "EEEEE"

CONCEPT_TO_RULE = {
    'use only capital letters': "all_caps",
    'make sure that words in your entire response are in all lowercase letters': "all_lowercase",
    'respond only in Chinese, and no other language is allowed': "chinese",
    'respond only in Spanish, and no other language is allowed': "spanish",
    'respond only in Korean, and no other language is allowed': "korean",
    'respond with emojis': "emoji",
    "include at least 4 hashtags, starting with '#'": "hashtags",
    'use exclamation marks in your response': "exclamation",
    'include citations and references with urls': "citations",
    'first repeat "Here is my response", then give your answer': "start_phrase",
    'the very last sentence of your response should be "Is there anything else I can help with?"': "help_phrase",
    'every sentence ends with the letter y': "same_letter_ending",
    'include a proper email address in your response': "email",
    'respond with at least 800 words': "word_limit_min",
    'include a telephone number in your response': "telephone_number",
    'include a postscript at the end of your response that starts with P.S.': "postscript",
    "include both of the keywords 'beauty' and 'pretty'": "keyword",
    'wrap your entire answer in JSON format': "json_format",
    'respond in number bullet list 1.\\n\\n2.\\n\\n and so on': "numbered_list",
    'separate paragraphs by double line breaks ("\\n\\n")': "double_breaks",
    'separate the paragraphs with ***': "asterisk_sep",
    'wrap every word in your response with double quotation marks': "quoted_words"
}