# Copyright (c) 2024, NVIDIA CORPORATION.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

only_text = [
    {
      "question": "Robbery is an act of forcibly seizing public and private property by violence, coercion or other means on the spot for the purpose of illegal possession. Which of the followings belongs to robbery \nOptions:\n(A) Li embedded himself in Wang's house to steal. When he was found, he ran away with the stolen goods. Wang pursued him closely. Li saw an unsteaded motorcycle next to the grocery store. The owner was smoking next to the motorcycle, so he rode on the motorcycle\n(B) Zheng riding a motorcycle saw Tian walking with an exquisite leather bag, pulling the leather bag belt from behind and trying to grab the leather bag. Tian grabbed the leather bag belt. Seeing this scene, Zheng suddenly accelerated the motorcycle and pulled the leather bag belt hard to grab the leather bag. Tian was immediately seriously injured\n(C) One night, when I saw Zhao walking alone in the street, I acted maliciously, raped him, and took away his bags and other things that showed his identity\n(D) Lin sneaked into Hu's house to steal valuables. After being found by the owner, he fled and hid in the farmer's haystack for a night. The next day, the village head Gao passed by and found Lin's whereabouts strange. Lin thought GAO found his theft last night and attacked Gao, causing him serious injury",
      "reference_solution": "",
      "generated_solution": "Robbery is defined as forcibly seizing public and private property by violence, coercion or other means on the spot for the purpose of illegal possession. Option B represents a situation where Zheng forcibly seized Tian's leather bag using violence (pulling the leather bag's belt hard enough to seriously injure Tian), which aligns with the definition of robbery. The other options do involve theft, assaults, and even rape, but they do not fit the specific definition of robbery as provided in the problem. So the answer is \\boxed{(B)}."
    },
    {
      "question": "Students asked by a psychologist to tell a lie before discussion groups vastly overestimated how many people in the discussion groups could tell they were lying. Other research has found that when volleyball players perform unusually poorly on the court, teammates notice this far less often than the players expect. Finally, in one research experiment a student wearing a funny T-shirt entered a room full of people. Questioning revealed that only a small fraction of the people in the room noticed the shirt, contrary to the student' s expectations. Which one of the following is best illustrated by the statements above? \nOptions:\n(A) People tend to believe their appearance and behavior are noticed by others more often than is actually the case.\n(B) People tend not to notice the appearance or behavior of others.\n(C) We are actually less observant of the appearance and behavior of others than we think ourselves to be.\n(D) People tend to be far less aware of their own appearance and behavior than are other people.",
      "reference_solution": "",
      "generated_solution": "The different pieces of information provided in the question - students overestimating how many people noticed their lies, volleyball players expecting more awareness from their teammates about their poor performance, or the student assuming more people noticed their funny T-shirt - cumulatively suggest a broader pattern. The common point in these cases is that individuals believe their behavior or appearances to be more noticed than they actually are. This pattern aligns with statement A, suggesting that people tend to believe their appearance and behavior are noticed by others more often than is actually the case. The other options do not capture the pattern of overestimation indicated in the premises. Therefore, using deductive reasoning, the most fitting conclusion is option \\boxed{(A)}."
    },
    {
      "question": "A scientific study provides evidence that crows are capable of recognizing threatening people and can even pass their concerns on to other crows. Researchers wearing rubber caveman masks trapped wild crows and then released them in the same area. Years later, people wearing the same masks near where the crows had been trapped were shrieked at and dive-bombed by crows. The argument depends on the assumption that \nOptions:\n(A) crows can distinguish between people who are wearing caveman masks and those who are not, but they cannot recognize individual human faces -17-\n(B) some of the crows that shrieked at and dive-bombed people wearing the masks were not among the crows that had been trapped\n(C) most birds of any species will regard a person as threatening if they see crows shrieking at and dive-bombing that person\n(D) even in places where crows have never been captured, most crows will shriek at and dive-bomb people wearing caveman masks",
      "reference_solution": "",
      "generated_solution": "The argument implies that crows can remember events that are threatening to them, and not only do they remember, but they also communicate this information to other crows. The only assumption that could make this argument valid is if some of the crows that shrieked and dive-bombed people wearing the masks were not among the crows that had been trapped. Therefore, the answer is \\boxed{(B)}."
    },
]

# Solutions are deductive
deductive = [
    {
      "question": "A logical deduction task which requires deducing the order of a sequence of objects.\nQ: The following paragraphs each describe a set of three objects arranged in a fixed order. The statements are logically consistent within each paragraph. On a shelf, there are three books: a white book, a green book, and an orange book. The green book is to the right of the white book. The orange book is the rightmost.\nOptions:\n(A) The white book is the leftmost\n(B) The green book is the leftmost\n(C) The orange book is the leftmost",
      "reference_solution": "[Deductive Reasoning] Look at the specific facts or conditions provided in the question. Using the general rule and the specific premises, deduce what must logically follow. A valid deductive argument guarantees the truth of the conclusion if the premises are true. Review each possible candidate provided in the problem and determine which one, if any, aligns with your deduced conclusion.",
      "generated_solution": "(1) The green book is to the right of the white book: \"(left) ? white ? green ? (right)\".\n(2) The orange book is the rightmost: \"(left) ? white ? green orange (right)\".\n(3) Combining (1) and (2) we get the following ordering: \"(left) white green orange (right)\".\nAccording to this ordering, the leftmost book is the white book.\nThe white book is the leftmost. So the answer is \\boxed{(A)}."
    },
    {
      "question": "A task requiring determining the final positions of a set of objects given their initial positions and a description of a sequence of swaps.\nQ: Alice, Bob, and Claire are dancers at a square dance. At the start of a song, they each have a partner: Alice is dancing with Lola, Bob is dancing with Rodrigo, and Claire is dancing with Patrick.\nThroughout the song, the dancers often trade partners. First, Alice and Bob switch partners. Then, Claire and Bob switch partners. Finally, Bob and Alice switch partners. At the end of the dance, Alice is dancing with\nOptions:\n(A) Lola\n(B) Rodrigo\n(C) Patrick",
      "reference_solution": "[Deductive Reasoning] Look at the specific facts or conditions provided in the question. Using the general rule and the specific premises, deduce what must logically follow. A valid deductive argument guarantees the truth of the conclusion if the premises are true. Review each possible candidate provided in the problem and determine which one, if any, aligns with your deduced conclusion.",
      "generated_solution": "(0) At the start: Alice: Lola, Bob: Rodrigo, Claire: Patrick.\n(1) Alice and Bob switch partners: Alice: Rodrigo, Bob: Lola, Claire: Patrick.\n(2) Claire and Bob switch partners: Alice: Rodrigo, Bob: Patrick, Claire: Lola.\n(3) Bob and Alice switch partners: Alice: Patrick, Bob: Rodrigo, Claire: Lola.\nAt the end of the dance, Alice is dancing with Patrick. So the answer is \\boxed{(C)}."
    },
    {
      "question": "The sun emits two types of ultraviolet radiation that damage skin: UV-A, which causes premature wrinkles, and UV-B, which causes sunburn. Until about ten years ago, sunscreens protected against UV-B radiation but not against UV-A radiation. Which one of the following is best supported by the information above? \nOptions:\n(A) People who wear sunscreen now are less likely to become sunburned than were people who spent the same amount of time in the sun wearing sunscreen ten years ago.\n(B) The specific cause of premature skin wrinkling was not known until about ten years ago.\n(C) Most people whose skin is prematurely wrinkled have spent a large amount of time in the sun without wearing sunscreen.\n(D) Until about ten years ago, people who wore sunscreen were no less likely to have premature wrinkles than were people who spent the same amount of time in the sun without wearing sunscreen.",
      "reference_solution": "[Deductive Reasoning] Look at the specific facts or conditions provided in the question. Using the general rule and the specific premises, deduce what must logically follow. A valid deductive argument guarantees the truth of the conclusion if the premises are true. Review each possible candidate provided in the problem and determine which one, if any, aligns with your deduced conclusion.",
      "generated_solution": "The question provides two pieces of information. One, we know that UV-A and UV-B both cause skin damage. Two, we know that until about ten years ago, sunscreens only protected against UV-B, not UV-A. Considering these premises, it's logical to conclude that people who wore sunscreen up until ten years ago were no less likely to get premature wrinkles (caused by UV-A) than those who didn't wear sunscreen, because the sunscreen in use at that time did not protect against UV-A radiation. Therefore, Option \\boxed{(D)} aligns with the deduced conclusion."
    },
    {
      "question": "Name geometric shapes from their SVG paths.\nQ: This SVG path element <path d=\"M 14.19,26.04 L 51.43,39.21 L 58.44,36.69 L 56.63,30.17 L 48.53,26.66 L 14.19,26.04\"/> draws a\nOptions:\n(A) circle\n(B) heptagon\n(C) hexagon\n(D) kite\n(E) line\n(F) octagon\n(G) pentagon\n(H) rectangle\n(I) sector\n(J) triangle",
      "reference_solution": "[Deductive Reasoning] Look at the specific facts or conditions provided in the question. Using the general rule and the specific premises, deduce what must logically follow. A valid deductive argument guarantees the truth of the conclusion if the premises are true. Review each possible candidate provided in the problem and determine which one, if any, aligns with your deduced conclusion.",
      "generated_solution": "This SVG path element contains \"M\" and \"L\" commands. M takes two parameters (x,y) and moves the current point to the coordinates (x,y). L takes two parameters (x,y) and draws a line from the previous coordinate to the new coordinate (x,y).\nThis path can be decomposed into 6 separate commands.\n(1) M 14.19,26.04: Move the current point to 14.19,26.04.\n(2) L 51.43,39.21: Create a line from 14.19,26.04 to 51.43,39.21.\n(3) L 58.44,36.69: Create a line from 51.43,39.21 to 58.44,36.69.\n(4) L 56.63,30.17: Create a line from 58.44,36.69 to 56.63,30.17.\n(5) L 48.53,26.66: Create a line from 56.63,30.17 to 48.53,26.66.\n(6) L 14.19,26.04: Create a line from 48.53,26.66 to 14.19,26.04.\nThis SVG path starts at point 14.19,26.04, creates five consecutive and touching lines, and then returns back its starting point, thereby creating a five-sided shape. It does not have any curves or arches. \"pentagon\" is the only five-sided polygon on the list. So the answer is \\boxed{(G)}."
    },
    {
      "question": "Recommend movies similar to the given list of movies.\nQ: Find a movie similar to Star Wars Episode IV - A New Hope, Indiana Jones and the Last Crusade, Star Wars Episode V - The Empire Strikes Back, The Big Lebowski:\nOptions:\n(A) Tetsuo\n(B) the Ironman\n(C) The Princess Bride\n(D) The Barkley Marathons The Race That Eats Its Young\n(E) BugOptions:\n(A) People who wear sunscreen now are less likely to become sunburned than were people who spent the same amount of time in the sun wearing sunscreen ten years ago.\n(B) The specific cause of premature skin wrinkling was not known until about ten years ago.\n(C) Most people whose skin is prematurely wrinkled have spent a large amount of time in the sun without wearing sunscreen.\n(D) Until about ten years ago, people who wore sunscreen were no less likely to have premature wrinkles than were people who spent the same amount of time in the sun without wearing sunscreen.",
      "reference_solution": "[Deductive Reasoning] Look at the specific facts or conditions provided in the question. Using the general rule and the specific premises, deduce what must logically follow. A valid deductive argument guarantees the truth of the conclusion if the premises are true. Review each possible candidate provided in the problem and determine which one, if any, aligns with your deduced conclusion.",
      "generated_solution": "- Star Wars Episode IV - A New Hope (action, adventure, fantasy; 1977)\n- Indiana Jones and the Last Crusade (action, adventure; 1989)\n- Star Wars Episode V - The Empire Strikes Back (action, adventure, fantasy; 1980)\n- The Big Lebowski (action, drama, comedy; 1998)\nThese are all famous classic American movies produced before 2000. Amongst all the options, the only movie similar to these ones seems to be The Princess Bride (1987). So the answer is \\boxed{(C)}."
    },
  ]

# Solutions are inductive
inductive = [
    {
      "question": "Reading is a personal life habit, which is determined by cultural literacy. Without the pursuit of knowledge or the hobby of culture, it is difficult to imagine that people can calm down and read. The habit of reading should be cultivated from an early age. Starting from the beginning, only the love and pursuit of cultural knowledge can make us accustomed to reading. The reading habits and hobbies of Chinese people cannot be solved by a youth reading festival. Therefore, reading is still based on usual habits. Which one of the followings is the topic of the above? \nOptions:\n(A) Reading habits\n(B) Advocate reading\n(C) Love reading since childhood\n(D) Pursue knowledge",
      "reference_solution": "[Inductive Reasoning] Induction is the process of making broad generalizations from specific observations. It involves looking at specific examples or scenarios within a text and forming broader, generalized conclusions from them.",
      "generated_solution": "Given the provided text, the overarching topic can be inferred by identifying common themes and the main message across the different lines. Although components like promoting reading, encouraging reading from a young age, and pursuing knowledge appear, the text mostly centers around the theme of reading habits—how they are formed, influenced, and why they're persistent. By piecing together these observations, one can inductively determine that the broadest topic covered is reading habits. So the answer is \\boxed{(A)}."
    },
    {
      "question": "The reason why the financial crisis has spread to the world is largely because each economy has experienced 6 to 7 years of extraordinary financial expansion, financial innovation and the unprecedented development of financial derivatives during the economic prosperity period. Under this model, the prices of various assets are constantly being irrationally pushed up. The key to the governance crisis is to return various assets that have been hyped to high prices to their reasonable price levels. A period of asset devaluation is inevitable. , This is the debt repayment for the past speeding appreciation. Which of the following is an accurate summary of the passage? \nOptions:\n(A) Proactive fiscal policy and appropriately loose monetary policy should be adopted to stimulate the economy\n(B) Stimulating the economy but also deflating the bubble\n(C) The goal of a stimulus is to get the economy moving again\n(D) High levels of asset prices should be maintained through government action or propaganda",
      "reference_solution": "[Inductive Reasoning] Induction is the process of making broad generalizations from specific observations. It involves looking at specific examples or scenarios within a text and forming broader, generalized conclusions from them.",
      "generated_solution": "By internalizing the details of the described financial crisis scenario, its causes, and suggested solutions, we can conceptualize a summary that encapsulates the key elements of the narration provided. From the passage, it's evident that the primary issue discussed is the over-inflation of asset prices following an extended period of financial frothiness, and the narrative pushes towards the necessity of reducing these inflated values to more reasonable levels as a corrective measure. Option (B), “Stimulating the economy but also deflating the bubble,” captures the necessity of economic stimulation while concurrently addressing the need to bring asset prices back to reality, which are the core components of the discussed solution to the described crisis. This option succinctly embodies the essence of the passage, making it the best summary using inductive reasoning from the provided details. So the answer is \\boxed{(B)}."
    },
    {
      "question": "Students asked by a psychologist to tell a lie before discussion groups vastly overestimated how many people in the discussion groups could tell they were lying. Other research has found that when volleyball players perform unusually poorly on the court, teammates notice this far less often than the players expect. Finally, in one research experiment a student wearing a funny T-shirt entered a room full of people. Questioning revealed that only a small fraction of the people in the room noticed the shirt, contrary to the student' s expectations. Which one of the following is best illustrated by the statements above? \nOptions:\n(A) People tend to believe their appearance and behavior are noticed by others more often than is actually the case.\n(B) People tend not to notice the appearance or behavior of others.\n(C) We are actually less observant of the appearance and behavior of others than we think ourselves to be.\n(D) People tend to be far less aware of their own appearance and behavior than are other people.",
      "reference_solution": "[Inductive Reasoning] Induction is the process of making broad generalizations from specific observations. It involves looking at specific examples or scenarios within a text and forming broader, generalized conclusions from them.",
      "generated_solution": "Using inductive reasoning, we extrapolate from specific instances or detailed observations provided to form broader generalized conclusions. By examining each of the scenarios mentioned — students overestimating being caught in lies, volleyball players overestimating their teammates noticing their poor performance, and the student being incorrect about how noticeable their funny T-shirt was — we notice a common theme. All these examples indicate that individuals overestimate the level and extent of attention their actions, appearances, or behaviors receive from others. This consistency across different contexts illustrates a broader psychological phenomenon. Option (A) best encapsulates this pattern identified from the examples given. The other options either narrow the focus unnecessarily, miss key aspects of the pattern, or misinterpret the data. Thus, inductive reasoning supports selecting option (A) as the most accurate summary of the evidence provided. So the answer is \\boxed{(A)}."
    },
  ]

# Solutions use analogical
analogical = [
    {
      "question": "For a certain type of ulcer, traditional therapy can completely heal 44\% of patients' ulcers within 6 months. A new therapy for this type of ulcer has achieved obvious improves in 80% of the ulcers treated in a 6-month trial. 61% of ulcers were healed. Since the trial only treated those ulcers very severe, this new treatment is obviously more effective than traditional treatments. In order to better compare the effects of the two therapies, is there any additional evidence that needs to be added? \nOptions:\n(A)  What is the difference between the methods used in the two therapies?\n(B)  Is there a big difference in the cost of the two therapies?\n(C)  What is the proportion of patients with this type of ulcer, treated under traditional therapies in 6 months, who have achieved significant improvement?\n(D)  Among the patients who participated in the 6-month trial of the new therapy, what percentage of the people were dissatisfied with the recovery rate?",
      "reference_solution": "[Analogical Reasoning] Retrieve several similar cases and draw the conclusion of this problem based on the similarity.",
      "generated_solution": "The conclusion that the new treatment is more effective is based on the improvement and healing rates of the ulcers. Thus, to better compare the two therapies, we would need to have analogous data for both. We know the healing rate for ulcers under the new therapy and the traditional therapy, but only the improvement rate for the new therapy. Therefore, more information is needed about the improvement rate under the traditional therapy as suggested in option C, to make a fair comparison. The other options do not pertain to the effectiveness of the therapies which is the main focus of the question. Therefore, option \\boxed{(C)} is most likely the correct answer."
    },
    {
      "question": "Robbery is an act of forcibly seizing public and private property by violence, coercion or other means on the spot for the purpose of illegal possession. Which of the followings belongs to robbery \nOptions:\n(A) Li embedded himself in Wang's house to steal. When he was found, he ran away with the stolen goods. Wang pursued him closely. Li saw an unsteaded motorcycle next to the grocery store. The owner was smoking next to the motorcycle, so he rode on the motorcycle\n(B) Zheng riding a motorcycle saw Tian walking with an exquisite leather bag, pulling the leather bag belt from behind and trying to grab the leather bag. Tian grabbed the leather bag belt. Seeing this scene, Zheng suddenly accelerated the motorcycle and pulled the leather bag belt hard to grab the leather bag. Tian was immediately seriously injured\n(C) One night, when I saw Zhao walking alone in the street, I acted maliciously, raped him, and took away his bags and other things that showed his identity\n(D) Lin sneaked into Hu's house to steal valuables. After being found by the owner, he fled and hid in the farmer's haystack for a night. The next day, the village head Gao passed by and found Lin's whereabouts strange. Lin thought GAO found his theft last night and attacked Gao, causing him serious injury",
      "reference_solution": "[Analogical Reasoning] Retrieve several similar cases and draw the conclusion of this problem based on the similarity.",
      "generated_solution": "Using analogous reasoning, we can compare the acts in the options to the definition given for robbery. Option B has the most similarity with the definition because it involves a forcible seizure of private property through violence, which is similar to the act of Zheng forcibly taking Tian's leather bag and causing serious injury in the process. The others, although they involve theft and acts of violence, do not align directly with the precise definition of robbery provided. So the answer is \\boxed{(B)}."
    },
    {
      "question": "Students asked by a psychologist to tell a lie before discussion groups vastly overestimated how many people in the discussion groups could tell they were lying. Other research has found that when volleyball players perform unusually poorly on the court, teammates notice this far less often than the players expect. Finally, in one research experiment a student wearing a funny T-shirt entered a room full of people. Questioning revealed that only a small fraction of the people in the room noticed the shirt, contrary to the student' s expectations. Which one of the following is best illustrated by the statements above? \nOptions:\n(A) People tend to believe their appearance and behavior are noticed by others more often than is actually the case.\n(B) People tend not to notice the appearance or behavior of others.\n(C) We are actually less observant of the appearance and behavior of others than we think ourselves to be.\n(D) People tend to be far less aware of their own appearance and behavior than are other people.",
      "reference_solution": "[Analogical Reasoning] Retrieve several similar cases and draw the conclusion of this problem based on the similarity.",
      "generated_solution": "Looking at the three statements; students lying, volleyball players performing poorly and the student wearing a funny T-shirt, we can see a similarity in all of them - the individuals in each scenario expected others to notice their actions or appearance to a greater extent than they actually did. This suggests that we tend to overestimate the attention that others pay to us, leading us to the conclusion that people believe their appearance and behavior are noticed by others more often than is actually the case (option A). However, this does not imply the other options: that people do not notice the appearance or behavior of others (option B), that we are less observant than we think we are (option C) or that people are less aware of their own appearance than are others (option D). Therefore, using analogical reasoning, option \\boxed{(A)} appears to be the correct answer."
    }
  ]

# Solutions use abductive
abductive = [
    {
      "question": "A college will continue to implement the overseas funding plan this year. It plans to select several of the six teachers from Mr. Liu, Mr. Zhang, Mr. Wang, Mr. Ma, Mr. Niu and Mr. Zhou to visit abroad. Due to the limitations of funding, the needs of discipline development, curriculum arrangement, place and time of each student's visit, the selection shall meet the following conditions: (1) Mr. Liu is the reserve discipline leader of the college, This time we have to send out. (2) if we choose Mr. Liu, we should also choose Mr. Zhou, but we can't choose Mr. Zhang. (3) only if Mr. Niu can't choose, at least one of Mr. Wang and Mr. Ma can choose. (4) if we don't choose Mr. Wang, we don't choose Mr. Zhou either. If the above statement is true, which of the followings must be true? \nOptions:\n(A) Mr. Niu didn't choose, but Mr. Zhou did\n(B) Mr. Liu was chose, but Mr. Ma didn't\n(C) Mr. Wang and Mr. Ma were chosen\n(D) Neither Mr. Wang nor Mr. Niu was elected",
      "reference_solution": "[Abductive Reasoning] Assume one candidate is correct and check whether it meets the condition in the problem.",
      "generated_solution": "Using the abductive reasoning, if option (A) is assumed to be true i.e. Mr. Niu didn't choose but Mr. Zhou did. This would meet condition (1), as Mr. Liu would be chosen along with Mr. Zhou. Condition (3) is also met, as Mr. Niu is not chosen, and we can choose either Mr. Wang or Mr. Ma but not necessarily both. Lastly, condition (4) can also be satisfied given that Mr. Zhou is chosen, therefore Mr. Wang can or cannot be chosen. So, this assumption meets all the conditions and hence option \\boxed{(A)} must be true."
    },
    {
      "question": "For a certain type of ulcer, traditional therapy can completely heal 44\% of patients' ulcers within 6 months. A new therapy for this type of ulcer has achieved obvious improves in 80% of the ulcers treated in a 6-month trial. 61% of ulcers were healed. Since the trial only treated those ulcers very severe, this new treatment is obviously more effective than traditional treatments. In order to better compare the effects of the two therapies, is there any additional evidence that needs to be added? \nOptions:\n(A)  What is the difference between the methods used in the two therapies?\n(B)  Is there a big difference in the cost of the two therapies?\n(C)  What is the proportion of patients with this type of ulcer, treated under traditional therapies in 6 months, who have achieved significant improvement?\n(D)  Among the patients who participated in the 6-month trial of the new therapy, what percentage of the people were dissatisfied with the recovery rate?",
      "reference_solution": "[Abductive Reasoning] Assume one candidate is correct and check whether it meets the condition in the problem.",
      "generated_solution": "Assuming option C is correct, additional information on the proportion of patients showing significant improvement under traditional therapy would provide a more concrete comparison between the two therapies. This would illustrate whether the new therapy is more effective in significantly improving patients' ulcers within a 6-month period when compared to the traditional therapy. Therefore, option \\boxed{(C)} meets the condition in the problem and is the correct answer."
    },
    {
      "question": "Students asked by a psychologist to tell a lie before discussion groups vastly overestimated how many people in the discussion groups could tell they were lying. Other research has found that when volleyball players perform unusually poorly on the court, teammates notice this far less often than the players expect. Finally, in one research experiment a student wearing a funny T-shirt entered a room full of people. Questioning revealed that only a small fraction of the people in the room noticed the shirt, contrary to the student' s expectations. Which one of the following is best illustrated by the statements above? \nOptions:\n(A) People tend to believe their appearance and behavior are noticed by others more often than is actually the case.\n(B) People tend not to notice the appearance or behavior of others.\n(C) We are actually less observant of the appearance and behavior of others than we think ourselves to be.\n(D) People tend to be far less aware of their own appearance and behavior than are other people.",
      "reference_solution": "[Abductive Reasoning] Assume one candidate is correct and check whether it meets the condition in the problem.",
      "generated_solution": "First, if we assume option (A) is correct, it is in line with all the statements in the problem. The students who told lies, the volleyball players and the student wearing the funny T-shirt all believed they would be noticed by others more often than what was actually noticed. So (A) fits the condition. Now, let's evaluate the other options: (B) goes beyond the information we have, as we can't infer from the data given that people tend not to notice the appearance or behavior of others at all times. (C) refers to our self-perception of our own level of observation, which is not a topic the problem addresses. Finally, (D) contrasts with the data given, as the problem mentions people tend to overestimate how often others are aware of their actions. Therefore, it is incorrect. So \\boxed{(A)} is the answer."
    },
    {
      "question": "The sun emits two types of ultraviolet radiation that damage skin: UV-A, which causes premature wrinkles, and UV-B, which causes sunburn. Until about ten years ago, sunscreens protected against UV-B radiation but not against UV-A radiation. Which one of the following is best supported by the information above? \nOptions:\n(A) People who wear sunscreen now are less likely to become sunburned than were people who spent the same amount of time in the sun wearing sunscreen ten years ago.\n(B) The specific cause of premature skin wrinkling was not known until about ten years ago.\n(C) Most people whose skin is prematurely wrinkled have spent a large amount of time in the sun without wearing sunscreen.\n(D) Until about ten years ago, people who wore sunscreen were no less likely to have premature wrinkles than were people who spent the same amount of time in the sun without wearing sunscreen.",
      "reference_solution": "[Abductive Reasoning] Assume one candidate is correct and check whether it meets the condition in the problem.",
      "generated_solution": "By assuming option (D) to be correct, we can infer that until about ten years ago, sunscreens only protected against UV-B radiation thus people wearing sunscreen were still likely to have premature wrinkles due to exposure to UV-A radiation. This matches with the information provided in the problem statement, hence, option \\boxed{(D)} best fits the given conditions."
    },
    {
      "question": "A scientific study provides evidence that crows are capable of recognizing threatening people and can even pass their concerns on to other crows. Researchers wearing rubber caveman masks trapped wild crows and then released them in the same area. Years later, people wearing the same masks near where the crows had been trapped were shrieked at and dive-bombed by crows. The argument depends on the assumption that \nOptions:\n(A) crows can distinguish between people who are wearing caveman masks and those who are not, but they cannot recognize individual human faces -17-\n(B) some of the crows that shrieked at and dive-bombed people wearing the masks were not among the crows that had been trapped\n(C) most birds of any species will regard a person as threatening if they see crows shrieking at and dive-bombing that person\n(D) even in places where crows have never been captured, most crows will shriek at and dive-bomb people wearing caveman masks",
      "reference_solution": "[Abductive Reasoning] Assume one candidate is correct and check whether it meets the condition in the problem.",
      "generated_solution": "Assuming option B to be correct, the behaviour of the crows that weren't among the ones trapped, especially the dive-bombing and shrieking, suggests they might have somehow learned to recognize the \u201cthreat\u201d represented by the mask. The instance where other crows reacted to the same masks years later may suggest that information about the threat posed was passed on to other crows. This meets the condition in the problem, therefore \\boxed{(B)} is correct."
    }
  ]
# Solutions are symbolize
symbolize = [
    {
      "question": "Robbery is an act of forcibly seizing public and private property by violence, coercion or other means on the spot for the purpose of illegal possession. Which of the followings belongs to robbery \nOptions:\n(A) Li embedded himself in Wang's house to steal. When he was found, he ran away with the stolen goods. Wang pursued him closely. Li saw an unsteaded motorcycle next to the grocery store. The owner was smoking next to the motorcycle, so he rode on the motorcycle\n(B) Zheng riding a motorcycle saw Tian walking with an exquisite leather bag, pulling the leather bag belt from behind and trying to grab the leather bag. Tian grabbed the leather bag belt. Seeing this scene, Zheng suddenly accelerated the motorcycle and pulled the leather bag belt hard to grab the leather bag. Tian was immediately seriously injured\n(C) One night, when I saw Zhao walking alone in the street, I acted maliciously, raped him, and took away his bags and other things that showed his identity\n(D) Lin sneaked into Hu's house to steal valuables. After being found by the owner, he fled and hid in the farmer's haystack for a night. The next day, the village head Gao passed by and found Lin's whereabouts strange. Lin thought GAO found his theft last night and attacked Gao, causing him serious injury",
      "reference_solution": "[Symbolize Reasoning] Use logical operations such as modus ponens (if p then q; p, therefore q), modus tollens (if p then q; not q, therefore not p), disjunctions, and conjunctions, among others, to evaluate the premises and infer conclusions.",
      "generated_solution": "In option B, Zheng uses force (Accelerates motorcycle and pulls the leather bag belt hard) in order to steal a public property (Leather Bag) and causes serious/injury harm to the owner (Tian). This directly matches with the definition of robbery which states the using of force or violence to steal something. Whereas in other options, there is stealing and causing harm but it is not done on the spot for the purpose of illegal possession. So, according to the rule of modus ponens, if the definition of robbery has all elements of forced stealing of property and causing injury (premise), and an option matches all those elements (premise), then that option can be considered as a case of robbery (conclusion). Therefore, option \\boxed{(B)} is a case of robbery."
    },
    {
      "question": "When the development of the enterprise organization is slow and bad problems occur internally, the enterprise must change the management mode. When the external change has little impact, the enterprise can make small adjustments from the daily management details to adapt to the change. When small adjustments cannot adapt to changes, enterprises need to consider management change. It should be noted that adaptive adjustment and management change may not be 100\% successful, but if they do not make adjustments or changes, the operation of enterprises will inevitably fail. With regard to this paragraph, which of the following understanding is accurate? \nOptions:\n(A) The slow development of enterprises often indicates that there are problems in enterprise management.\n(B) If there are bad problems within the enterprise, adaptive adjustment can be considered first.\n(C) The unsuccessful adjustment or change of enterprise management will lead to the failure of enterprise management.\n(D) The influence of external change is the decisive factor for enterprises to change their management mode.",
      "reference_solution": "[Symbolize Reasoning] Use logical operations such as modus ponens (if p then q; p, therefore q), modus tollens (if p then q; not q, therefore not p), disjunctions, and conjunctions, among others, to evaluate the premises and infer conclusions.",
      "generated_solution": "The paragraph states that 'when bad problems occur internally, the enterprise must change the management mode' and 'when the external change has little impact, the enterprise can make small adjustments from the daily management details to adapt to the change'. So, if p (there are bad problems within an enterprise), then q (the enterprise must change the management mode) and if not p (the external change doesn't have much impact), the enterprise can make small adjustments. This logic aligns with option B, which suggests that with internal issues, adaptive adjustment can be considered first, hence option \\boxed{(B)} is the accurate understanding of the paragraph."
    },
        {
      "question": "The reason why the financial crisis has spread to the world is largely because each economy has experienced 6 to 7 years of extraordinary financial expansion, financial innovation and the unprecedented development of financial derivatives during the economic prosperity period. Under this model, the prices of various assets are constantly being irrationally pushed up. The key to the governance crisis is to return various assets that have been hyped to high prices to their reasonable price levels. A period of asset devaluation is inevitable. , This is the debt repayment for the past speeding appreciation. Which of the following is an accurate summary of the passage? \nOptions:\n(A) Proactive fiscal policy and appropriately loose monetary policy should be adopted to stimulate the economy\n(B) Stimulating the economy but also deflating the bubble\n(C) The goal of a stimulus is to get the economy moving again\n(D) High levels of asset prices should be maintained through government action or propaganda",
      "reference_solution": "[Symbolize Reasoning] Use logical operations such as modus ponens (if p then q; p, therefore q), modus tollens (if p then q; not q, therefore not p), disjunctions, and conjunctions, among others, to evaluate the premises and infer conclusions.",
      "generated_solution": "Let's break down and symbolize the reasoning from the passage using logical operations to match the appropriate option:\n\n1. Premises Driven Analysis:\n   - Let p be 'economies experienced financial expansion, innovation, and growth in derivatives'.\n   - Let q be 'prices of various assets were irrationally pushed up'.\n   - Given: If p then q (financial expansions leading to high asset prices)\n   - We observe that q resulted in an undesirable financial condition.\n\n2. Resolution Proposal in the Passage:\n   - Let r be 'reduce hyped asset prices to reasonable levels'.\n   - Given: If q then r (if asset prices are too high, they need reducing)\n   - Conclusion drawn: r is necessary to solve the crisis.\n   - Crucially, it is also given that this reduction in asset prices is 'inevitable'.\n\n3. Matching Options with Conclusion r:\n   - Option (A) discusses stimulating the economy, which doesn't direct us towards reducing asset prices, merely economic stimulation.\n   - Option (B) 'Stimulating the economy but also deflating. So the answer is \\boxed{(B)}."
    },
  ]

examples_map = {
    "logic_text": only_text,
    "logic_deductive": deductive,
    "logic_inductive": inductive,
    "logic_analogical": analogical,
    "logic_abductive": abductive,
}
