# WISE: Rethinking the Knowledge Memory for Lifelong Model Editing of Large Language Models

### Requirements

```bash
conda create -n lifelong_edit python=3.9
conda activate lifelong_edit
```

First install the package:

```bash
pip install -r requirements.txt
```

### Dataset

The datasets used can be found in `./data` (ZsRE, Hallucination, Temporal)

Each dataset contains both an **edit set** and a train set. Except for MEND, all editing methods can directly edit and run on the edit set.

### Edit and Evaluation

**Config**

For reproducing experimental results, please refer to `./hparams/config.yaml`, which contains the configuration parameters used for the run.

```yaml
alg_name: "ROME"

ds_path: "ZsRE" # hallucination ZsRE temporal
model_name: "/YOUR_PATH/llama-2-7b" # model path
device: 0
output_dir: "./results"
hparams_file: "./hparams/ROME/llama-7B.yaml"
sequential_edit: true

verbose: true
```

- alg_name: editing method (including ROME, FT, FT-EWC, MEMIT, and WISE etc.), specifically implemented in the `./editor/models` directory.
- model_name: location of the model weights.
- hparams_file: configuration file for the hyperparameters of the editing method. The default can be used but the path should be modified according to alg_name. Refer to the `./hparams` folder for details.
- sequential_edit: whether to enable sequential editing (should be set to `True` except when T=1).

**Run**

```bash
python main.py
```
