from typing import Any, Dict, List, Tuple
import torch
from copy import deepcopy
from transformers import AutoModelForCausalLM, AutoTokenizer
from .Defer import Defer
from .defer_hparams import DeferHyperParams
from ..grace.utils import tokenize

def apply_defer_to_model(
        model: AutoModelForCausalLM,
        tok: AutoTokenizer,
        requests: List[Dict],
        hparams: Defer,
        copy=False,
        return_orig_weights=False,
        **kwargs: Any,
) -> Tuple[AutoModelForCausalLM, Dict[str, Any]]:
    request = requests
    if copy:
        model = deepcopy(model)
    editor = Defer(model=model, config=hparams, device=hparams.device)

    tokens = tokenize(request, tokenizer=tok, device=hparams.device)
    weights_copy = editor.reset_layer

    editor.edit(config=hparams, tokens=tokens)

    return editor, weights_copy


