from dataclasses import dataclass
from typing import List
from ...util.hparams import HyperParams
import yaml


@dataclass
class FTEWCHyperParams(HyperParams):
    # Experiments

    edit_lr: float
    n_iter: int
    fisher_mem: int
    ewc_lambda: float
    # Method
    # Module templates
    inner_params: List[str]

    # Defaults

    @classmethod
    def from_hparams(cls, hparams_name_or_path: str):
        if '.yaml' not in hparams_name_or_path:
            hparams_name_or_path = hparams_name_or_path + '.yaml'

        with open(hparams_name_or_path, "r") as stream:
            config = yaml.safe_load(stream)
            config = super().construct_float_from_scientific_notation(config)
        return cls(**config)
