#!/bin/bash
#SBATCH -A <your_proj_name>
#SBATCH --job-name=xgraad_test1_lws
#SBATCH -N 1 --gpus-per-node=A100:1
#SBATCH --output=xgraad_test1_lws.txt
#SBATCH -t 05:30:00

# Load necessary modules or activate your environment
module load Python/3.9.6-GCCcore-11.2.0
source <your_source_env_name>
declare -a model_names=("bert")
#declare -a model_names=("bert" "distilbert" "albert")
#declare -a model_names=("albert" "deberta" "roberta")
#declare -a ds_names=("imdb" "sst" "ag_news")
declare -a ds_names=("sst")
#declare -a attack_names=("BADNLI" "RIPPLES" "LWS")
declare -a attack_names=("LWS")
for a_name in ${attack_names[@]}; 
do
    for d_name in ${ds_names[@]};
    do
        for m_name in ${model_names[@]};
        do
            echo "Running X-GRAAD for: model=$m_name, dataset=$d_name, attack=$a_name"
            python x-graad.py --model_name=$m_name --ds_name=$d_name --attack_name=$a_name
        done
    done
done

deactivate