"""Implement various exploit strategies for PBT

Main idea: return a filiation list

father[i] = j

And if father[i] == i, i won't mutate
"""

import numpy as np
from typing import Callable


def winner_takes_all(share_best: float = 0.5) -> Callable:
    def winner_takes_all_func(sorted_players: np.ndarray) -> np.ndarray:
        n_total = len(sorted_players)
        n_best = int(share_best * n_total)
        father = np.arange(n_total)

        winners = sorted_players[:n_best]
        losers = sorted_players[n_best:]

        n_sons = (n_total - n_best) // n_best

        for i in range(n_best):
            father[losers[n_sons * i : n_sons * (i + 1)]] = [winners[i]] * n_sons

        return father

    return winner_takes_all_func


def truncation(share_best: float = 0.25) -> Callable:
    def truncation_func(sorted_players: np.ndarray) -> np.ndarray:
        n_total = len(sorted_players)
        n_best = int(share_best * n_total)
        father = np.arange(n_total)
        father[sorted_players[-n_best:]] = sorted_players[:n_best]
        return father

    return truncation_func


def random_search_exploitation(arg) -> Callable:
    def random_search_exploitation_func(sorted_players: np.ndarray) -> np.ndarray:
        father = np.arange(len(sorted_players))
        return father

    return random_search_exploitation_func


def tournament(k: int = 2) -> Callable:
    def tournament_func(sorted_players: np.ndarray) -> np.ndarray:
        n_total = len(sorted_players)
        father = np.arange(n_total)
        population = list(range(n_total))

        # Rebuild scores
        scores = np.empty_like(sorted_players)
        for i in range(len(sorted_players)):
            scores[sorted_players[i]] = -i

        for player in range(n_total):
            competitors = [player] + list(
                np.random.choice(
                    population[:player] + population[player + 1 :],
                    replace=False,
                    size=k - 1,
                )
            )

            winner = max(competitors, key=lambda x: scores[x])
            father[player] = winner

        return father

    return tournament_func
