# Latent Neural Operator for Solving Forward and Inverse PDE Problems

## Requirements
The dependencies required for running the codes are listed in the `requirements.txt`.

## Experiments
### Forward Problem
All the codes used to do the forward problem experiments are under the directory `Forward_Problem/`.

The dataset are proposed in public available in [FNO datasets](https://drive.google.com/drive/folders/1UnbQh2WWc6knEHbLn-ZaXrKUZhp7pjt-) and [GeoFNO datasets](https://drive.google.com/drive/folders/1YBuaoTdOSr_qzaow-G-iwvbUI7fiUzu8). Using `Forward_Problem/data_convert_*.py` to help preprocess the data downloaded from the two aforementioned links following the comments.

#### LNO
`cd Forward_Problem/LNO`
`./train.sh`
1. Remember to replace the \$config_name and \$exp_name in `train.sh` according to different benchmarks. \$config_name refers to which benchmark and set of hyperparameters will be used for training and \$exp_name refers to which directory under `Forward_Problem/experiments/` will store the running information such as checkpoints and logs.
2. To do ablation study, remember to modify the corresponding config file:
   - model.attn: one of ["Attention_Vanilla","Attention_Linear_GNOT","Galerkin","Nystrom"], which correspond to scaled dot-product attention, efficient attention, Galkerkin-type attention and Nystrom attenion (in Sec 4.3).
   - model.name: one of ["LNO","LNO_single","LNO_triple"] (espectially, ["LNO_time","LNO_single_time","LNO_triple_time"] for NS2d benchmark), which correspond to the original LNO, coupled LNO (in Sec 4.3) and non-shared LNO (in Appendix C).

#### Transolver
`cd Forward_Problem/Transolver` (especially, `cd Forward_Problem/Transolver_time` for NS2d benchmark)
`./train.sh`
1. Remember to replace the \$config_name and \$exp_name in `train.sh` according to different benchmarks. \$config_name refers to which benchmark and set of hyperparameters will be used for training and \$exp_name refers to which directory under `Forward_Problem/experiments/` will store the running information such as checkpoints and logs.

### Inverse Problem
All the codes used to do the inverse problem experiments are under the directory `Inverse_Problem/`

The dataset is generated through our script: 
`cd Inverse_Problem/codes`
`python data.py --data_name Burgers_IC_std`
The generated dataset is stored under `Forward_Problem/datas/`.

#### completer
`cd Inverse_Problem`
`./train_completer.sh`
`./test_completer.sh`
1. Remember to replace the \$config_name and epoch_num in `train.sh` and `test.sh` according to different completers (DeepONet, GNOT or LNO) and checkpoints. \$config_name refers to which completer and set of hyperparameters will be used for training, also refers to which directory under `Inverse_Problem/runs/` will store the running information such as checkpoints and logs.

#### propgator
`cd Inverse_Problem`
`./train_propgator.sh`
`./test_propgator.sh`
1. Remember to replace the \$config_name and epoch_num in `train.sh` and `test.sh` according to different propgators (DeepONet, GNOT or LNO) and checkpoints. \$config_name refers to which propgator and set of hyperparameters will be used for training, also refers to which directory under `Inverse_Problem/runs/` will store the running information such as checkpoints and logs.

#### completer+propagator
`cd Inverse_Problem`
`./infer.sh`
1. Remember to replace the \$config_name and epoch_num of completer and propagator respectively in `infer.sh`. 
2. The inference process will be based on pre-trained completers and propagators. First, the completer will be used to reconstruct complete solution in sub domain based on partial observation in sub domain. Then, the propagator will be used to reconstruct complete solution in the whole domain based on the complete solution in the sub domain. This accomplishes solving the inverse problem.
