import numpy as  np


# download airfoil/naca/NACA_Cylinder_*.npy
# from GeoFNO datasets (https://drive.google.com/drive/folders/1JUkPbx0-lgjFHPURH_kp1uqjfRn3aw9-)
# to Forward_Problem/datas

Q = np.expand_dims(np.load("data/NACA_Cylinder_Q.npy")[:,4,:,:], axis=-1)
X = np.expand_dims(np.load("data/NACA_Cylinder_X.npy"), axis=-1)
Y = np.expand_dims(np.load("data/NACA_Cylinder_Y.npy"), axis=-1)

x = []
for x1 in np.linspace(0, 1, 221):
    for x2 in np.linspace(0, 1, 51):
            x.append([x1, x2])

x = np.reshape(np.array(x), (221, 51, 2))
x = np.expand_dims(x, axis=0)
x = np.repeat(x, 1200, axis=0)

y1 = np.concatenate((X, Y), axis=-1)
y2 = Q

print(x.shape)
print(y1.shape)
print(y2.shape)

train_data = {"x":x[:1000,...], "y2":y2[:1000,...], "y1":y1[:1000,...]}
val_data = {"x":x[-200:,...], "y2":y2[-200:,...], "y1":y1[-200:,...]}
np.save("data/AR_train", train_data)
np.save("data/AR_val", val_data)

