# CNN Interpretability with Multivector Tucker Saliency Maps for Self-Supervised Models

This repository provides the official Pytorch implementation for Tucker Saliency Maps (TSM) and Multivector Tucker Saliency Maps (MTSM), a label-indenpendent interpratibility methods targeted mainly for CNN models, described in the paper **CNN Interpretability with Multivector Tucker Saliency Maps for Self-Supervised Models**, published in Transactions on Machine Learning research.

Authors : Aymene Mohammed Bouayed, Samuel Deslauriers-Gauthier, Adrian Iacovelli, David Naccache

DIÉNS, ÉNS, CNRS, PSL University, Paris, France

Be-Ys Research, France

Centre Inria d’Université Côte d’Azur, Nice, France

![Proposed TSM and MTSM methods  visualization.](./figures/method.png)

![Sample saliency maps generated through the TSM and MTSM methods compred label-independent methods.](./figures/sample.png)

## Envirement setup
Our methods run both on CPU and GPU. See requirements.txt for all prerequisites, and you can also install them using the following command : 
```
pip install -r requirements.txt
```


## Citation
```
@article{
    AMBouayed2025TSM,
    title={{CNN} Explainability with Multivector Tucker Saliency Maps for Self-Supervised Models},
    author={Aymene Mohammed Bouayed and Samuel Deslauriers-gauthier and Adrian Iacovelli and David Naccache},
    journal={Transactions on Machine Learning Research},
    year={2025},
    url={https://openreview.net/forum?id=3605}
}
```

## Contact
If you have any questions, feel free to contact me directly via ```aymene.bouayed@ens.fr```
