# What Doesn't Kill You Makes You Robust: Adversarial Training against Poisons and Backdoors

This folder can be used to replicate the adversarial defenses against data poisoning shown in the paper. The submitted code is a heavy modification of code found at https://github.com/JonasGeiping/poisoning-gradient-matching (one of the attacks considered in this work), **effectively forking that repository**.

This folder contains implementations of new attacks as well as the implementation of our proposed defense.

To attack, use the same structure as in the original code for some attack, described as  ``--recipe`` there.
```
python brew_poison --net Resnet18 --recipe gradient-matching --restarts 1
```
to defend, call the same code with the additional arguments ``--optimization defensive --defense_type adversarial-wb-recombine``, i.e.
```
python brew_poison --net Resnet18 --recipe gradient-matching --restarts 1 --optimization defensive --defense_type adversarial-wb-recombine
```

The `--defense_type` argument can be broken up into components, to ablate parts of the defense. Replacing the middle part `-wb-` (standing for Witches' Brew) with another attack, e.g. `-fc-` (for feature collision), allows for a different attack to be used during the defense.


All experiments shown in the paper can be found and replicated by running the scripts found under `scripts/`.
