/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.IntPair;
import java.io.BufferedReader;
import java.util.ArrayList;

public class Experiments {
    protected int[][] vArray;
    protected int[] px;
    protected int[] py;
    protected int[] maxY;
    protected int[][] pxy;
    public int xSize;
    public int ySize;
    private ArrayList<Experiments> v = new ArrayList();
    int dim = 7;
    public double[][] values;

    public Experiments() {
    }

    public Experiments(int[][] vArray) {
        this.vArray = vArray;
        this.ptilde();
    }

    public Experiments(int[][] vArray, int[] maxYs) {
        this.vArray = vArray;
        this.ptilde();
        this.maxY = maxYs;
    }

    public Experiments(int[][] vArray, int ySize) {
        this.vArray = vArray;
        this.ySize = ySize;
        this.ptilde(ySize);
    }

    public Index<IntPair> createIndex() {
        HashIndex<IntPair> index = new HashIndex<IntPair>();
        for (int x = 0; x < this.px.length; ++x) {
            int numberY = this.numY(x);
            for (int y = 0; y < numberY; ++y) {
                index.add(new IntPair(x, y));
            }
        }
        return index;
    }

    public Experiments(String filename) {
        try (BufferedReader in = IOUtils.readerFromString(filename);){
            Exception e1 = new Exception("Incorrect data file format");
            String head = in.readLine();
            if (!head.equals("<data>")) {
                throw e1;
            }
            String xLine = in.readLine();
            if (!xLine.startsWith("<xSize>")) {
                throw e1;
            }
            if (!xLine.endsWith("</xSize>")) {
                throw e1;
            }
            int index1 = xLine.indexOf(62);
            int index2 = xLine.lastIndexOf(60);
            String xSt = xLine.substring(index1 + 1, index2);
            System.out.println(xSt);
            this.xSize = Integer.parseInt(xSt);
            System.out.println("xSize is " + this.xSize);
            String yLine = in.readLine();
            if (!yLine.startsWith("<ySize>")) {
                throw e1;
            }
            if (!yLine.endsWith("</ySize>")) {
                throw e1;
            }
            index1 = yLine.indexOf(62);
            index2 = yLine.lastIndexOf(60);
            this.ySize = Integer.parseInt(yLine.substring(index1 + 1, index2));
            System.out.println("ySize is " + this.ySize);
            String nLine = in.readLine();
            if (!nLine.startsWith("<number>")) {
                throw e1;
            }
            if (!nLine.endsWith("</number>")) {
                throw e1;
            }
            index1 = nLine.indexOf(62);
            index2 = nLine.lastIndexOf(60);
            int number = Integer.parseInt(nLine.substring(index1 + 1, index2));
            System.out.println("number is " + number);
            this.vArray = new int[number][2];
            for (int current = 0; current < number; ++current) {
                String experiment = in.readLine();
                int index = experiment.indexOf(32);
                int x = Integer.parseInt(experiment.substring(0, index));
                int y = Integer.parseInt(experiment.substring(index + 1));
                this.vArray[current][0] = x;
                this.vArray[current][1] = y;
            }
            this.ptilde(this.ySize);
        }
        catch (Exception e) {
            System.out.println("Incorrect data file format");
            e.printStackTrace();
        }
    }

    public void add(Experiments m) {
        this.v.add(m);
    }

    public final void ptilde() {
        int maxX = 0;
        int maxY = 0;
        for (int[] sample : this.vArray) {
            if (maxX < sample[0]) {
                maxX = sample[0];
            }
            if (maxY >= sample[1]) continue;
            maxY = sample[1];
        }
        this.px = new int[maxX + 1];
        this.py = new int[maxY + 1];
        this.pxy = new int[maxX + 1][this.dim];
        this.xSize = maxX + 1;
        this.ySize = maxY + 1;
        int[] yArr = new int[this.dim];
        block1: for (int[] sample : this.vArray) {
            int j;
            int xC = sample[0];
            int yC = sample[1];
            int n = xC;
            this.px[n] = this.px[n] + 1;
            int n2 = yC;
            this.py[n2] = this.py[n2] + 1;
            for (j = 0; j < this.dim; ++j) {
                yArr[j] = this.pxy[xC][j] > 0 ? this.pxy[xC][j] % this.ySize : -1;
            }
            for (j = 0; j < this.dim; ++j) {
                if (yArr[j] == -1) {
                    this.pxy[xC][j] = this.ySize + yC;
                    continue block1;
                }
                if (yC != yArr[j]) continue;
                int[] nArray = this.pxy[xC];
                int n3 = j;
                nArray[n3] = nArray[n3] + this.ySize;
                continue block1;
            }
        }
        for (int y = 0; y < this.ySize; ++y) {
            double sum = 0.0;
            for (int x = 0; x < this.xSize; ++x) {
                double p1 = this.ptildeXY(x, y);
                sum += p1;
            }
            if (!(Math.abs(this.ptildeY(y) - sum) > 1.0E-5)) continue;
            System.out.println("Experiments error: for y=" + y + ", ptildeY(y)=" + this.ptildeY(y) + " but Sum_x ptildeXY(x,y)=" + sum);
        }
        this.maxY = new int[this.xSize];
        for (int j = 0; j < this.xSize; ++j) {
            this.maxY[j] = this.ySize;
        }
    }

    public void setMaxY(int[] maxY) {
        this.maxY = maxY;
    }

    public int numY(int x) {
        return this.maxY[x];
    }

    public void ptilde(int ySize) {
        int maxX = 0;
        int maxY = 0;
        this.ySize = ySize;
        for (int[] sample : this.vArray) {
            if (maxX < sample[0]) {
                maxX = sample[0];
            }
            if (maxY >= sample[1]) continue;
            maxY = sample[1];
        }
        this.px = new int[maxX + 1];
        maxY = ySize - 1;
        this.py = new int[ySize];
        this.pxy = new int[maxX + 1][this.dim];
        this.xSize = maxX + 1;
        ySize = maxY + 1;
        int[] yArr = new int[this.dim];
        block1: for (int[] sample : this.vArray) {
            int j;
            int xC = sample[0];
            int yC = sample[1];
            int n = xC;
            this.px[n] = this.px[n] + 1;
            int n2 = yC;
            this.py[n2] = this.py[n2] + 1;
            for (j = 0; j < this.dim; ++j) {
                yArr[j] = this.pxy[xC][j] > 0 ? this.pxy[xC][j] % ySize : -1;
            }
            for (j = 0; j < this.dim; ++j) {
                if (yArr[j] == -1) {
                    this.pxy[xC][j] = ySize + yC;
                    continue block1;
                }
                if (yC != yArr[j]) continue;
                int[] nArray = this.pxy[xC];
                int n3 = j;
                nArray[n3] = nArray[n3] + ySize;
                continue block1;
            }
        }
        System.out.println("ySize is" + ySize);
        for (int y = 0; y < ySize; ++y) {
            double sum = 0.0;
            for (int x = 0; x < this.xSize; ++x) {
                double p1 = this.ptildeXY(x, y);
                sum += p1;
            }
            if (Math.abs(this.ptildeY(y) - sum) > 1.0E-5) {
                System.out.println("Experiments error: for y=" + y + ", ptildeY(y)=" + this.ptildeY(y) + " but Sum_x ptildeXY(x,y)=" + sum);
                continue;
            }
            System.out.println("Experiments: for y " + y + " Sum_x ptildeXY(x,y)=" + sum);
        }
    }

    public double ptildeX(int x) {
        if (x > this.xSize - 1) {
            return 0.0;
        }
        return (double)this.px[x] / (double)this.vArray.length;
    }

    public double ptildeY(int y) {
        if (y > this.ySize - 1) {
            return 0.0;
        }
        return (double)this.py[y] / (double)this.size();
    }

    public double ptildeXY(int x, int y) {
        for (int j = 0; j < this.dim; ++j) {
            if (y != this.pxy[x][j] % this.ySize) continue;
            return (double)(this.pxy[x][j] / this.ySize) / (double)this.size();
        }
        return 0.0;
    }

    public int[] get(int index) {
        return this.vArray[index];
    }

    public int size() {
        return this.vArray.length;
    }

    public int getNumber() {
        return this.vArray.length;
    }

    public void print() {
        int i;
        System.out.println(" Experiments : ");
        for (i = 0; i < this.size(); ++i) {
            System.out.println(this.vArray[i][0] + " : " + this.vArray[i][1]);
        }
        System.out.println(" p(x) ");
        for (i = 0; i < this.xSize; ++i) {
            System.out.println(i + " : " + this.ptildeX(i));
        }
        System.out.println(" p(y) ");
        for (i = 0; i < this.ySize; ++i) {
            System.out.println(i + " : " + this.ptildeY(i));
        }
    }

    public void print(PrintFile pf) {
        int i;
        pf.println(" Experiments : ");
        for (i = 0; i < this.size(); ++i) {
            pf.println(this.vArray[i][0] + " : " + this.vArray[i][1]);
        }
        pf.println(" p(x) ");
        for (i = 0; i < this.xSize; ++i) {
            pf.println(i + " : " + this.ptildeX(i));
        }
        pf.println(" p(y) ");
        for (i = 0; i < this.ySize; ++i) {
            pf.println(i + " : " + this.ptildeY(i));
        }
    }
}

