/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.util.AbstractIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DelimitRegExIterator<T>
extends AbstractIterator<T> {
    private Iterator<String> tokens;
    private final Function<String, T> op;
    private T nextToken;

    public static DelimitRegExIterator<String> defaultDelimitRegExIterator(Reader in, String delimiter) {
        return new DelimitRegExIterator<String>(in, delimiter, new IdentityFunction());
    }

    public DelimitRegExIterator(Reader r, String delimiter, Function<String, T> op) {
        this.op = op;
        BufferedReader in = new BufferedReader(r);
        try {
            String line;
            StringBuilder input = new StringBuilder(10000);
            while ((line = in.readLine()) != null) {
                input.append(line).append('\n');
            }
            line = input.toString();
            Matcher m = Pattern.compile(delimiter).matcher(line);
            ArrayList<String> toks = new ArrayList<String>();
            int prev = 0;
            while (m.find()) {
                if (m.start() == 0) continue;
                toks.add(line.substring(prev, m.start()));
                prev = m.end();
            }
            if (prev < line.length()) {
                toks.add(line.substring(prev, line.length()));
            }
            this.tokens = toks.iterator();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        this.setNext();
    }

    private void setNext() {
        this.nextToken = this.tokens.hasNext() ? this.parseString(this.tokens.next()) : null;
    }

    protected T parseString(String s) {
        return this.op.apply(s);
    }

    @Override
    public boolean hasNext() {
        return this.nextToken != null;
    }

    @Override
    public T next() {
        if (this.nextToken == null) {
            throw new NoSuchElementException("DelimitRegExIterator exhausted");
        }
        T token = this.nextToken;
        this.setNext();
        return token;
    }

    public Object peek() {
        return this.nextToken;
    }

    public static IteratorFromReaderFactory<String> getFactory(String delim) {
        return DelimitRegExIteratorFactory.defaultDelimitRegExIteratorFactory(delim);
    }

    public static <T> IteratorFromReaderFactory<T> getFactory(String delim, Function<String, T> op) {
        return new DelimitRegExIteratorFactory<T>(delim, op);
    }

    public static class DelimitRegExIteratorFactory<T>
    implements IteratorFromReaderFactory<T> {
        private static final long serialVersionUID = 6846060575832573082L;
        private final String delim;
        private final Function<String, T> op;

        public static DelimitRegExIteratorFactory<String> defaultDelimitRegExIteratorFactory(String delim) {
            return new DelimitRegExIteratorFactory<String>(delim, new IdentityFunction());
        }

        public DelimitRegExIteratorFactory(String delim, Function<String, T> op) {
            this.delim = delim;
            this.op = op;
        }

        @Override
        public Iterator<T> getIterator(Reader r) {
            return new DelimitRegExIterator<T>(r, this.delim, this.op);
        }
    }
}

