/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalStructure;
import edu.stanford.nlp.trees.UniversalSemanticHeadFinder;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class SemanticGraphFactory {
    private static final Redwood.RedwoodChannels log = Redwood.channels(SemanticGraphFactory.class);
    private static final boolean INCLUDE_PUNCTUATION_DEPENDENCIES = false;

    private SemanticGraphFactory() {
    }

    public static SemanticGraph generateUncollapsedDependencies(Tree tree) {
        return SemanticGraphFactory.makeFromTree(tree, Mode.BASIC, GrammaticalStructure.Extras.NONE);
    }

    @Deprecated
    public static SemanticGraph generateCollapsedDependencies(Tree tree) {
        return SemanticGraphFactory.makeFromTree(tree, Mode.COLLAPSED, GrammaticalStructure.Extras.NONE);
    }

    @Deprecated
    public static SemanticGraph generateCCProcessedDependencies(Tree tree) {
        return SemanticGraphFactory.makeFromTree(tree, Mode.CCPROCESSED, GrammaticalStructure.Extras.NONE);
    }

    public static SemanticGraph generateEnhancedDependencies(Tree tree) {
        return SemanticGraphFactory.makeFromTree(tree, Mode.ENHANCED, GrammaticalStructure.Extras.NONE);
    }

    public static SemanticGraph generateEnhancedPlusPlusDependencies(Tree tree) {
        return SemanticGraphFactory.makeFromTree(tree, Mode.ENHANCED_PLUS_PLUS, GrammaticalStructure.Extras.NONE);
    }

    public static SemanticGraph generateUncollapsedDependencies(GrammaticalStructure gs) {
        return SemanticGraphFactory.makeFromTree(gs, Mode.BASIC, GrammaticalStructure.Extras.NONE, null);
    }

    @Deprecated
    public static SemanticGraph generateCollapsedDependencies(GrammaticalStructure gs) {
        return SemanticGraphFactory.makeFromTree(gs, Mode.COLLAPSED, GrammaticalStructure.Extras.NONE, null);
    }

    @Deprecated
    public static SemanticGraph generateCCProcessedDependencies(GrammaticalStructure gs) {
        return SemanticGraphFactory.makeFromTree(gs, Mode.CCPROCESSED, GrammaticalStructure.Extras.NONE, null);
    }

    public static SemanticGraph generateEnhancedDependencies(GrammaticalStructure gs) {
        return SemanticGraphFactory.makeFromTree(gs, Mode.ENHANCED, GrammaticalStructure.Extras.NONE, null);
    }

    public static SemanticGraph generateEnhancedPlusPlusDependencies(GrammaticalStructure gs) {
        return SemanticGraphFactory.makeFromTree(gs, Mode.ENHANCED_PLUS_PLUS, GrammaticalStructure.Extras.NONE, null);
    }

    @Deprecated
    public static SemanticGraph generateUncollapsedDependencies(GrammaticalStructure gs, GrammaticalStructure.Extras extras) {
        return SemanticGraphFactory.makeFromTree(gs, Mode.BASIC, extras, null);
    }

    @Deprecated
    public static SemanticGraph generateCollapsedDependencies(GrammaticalStructure gs, GrammaticalStructure.Extras extras) {
        return SemanticGraphFactory.makeFromTree(gs, Mode.COLLAPSED, extras, null);
    }

    @Deprecated
    public static SemanticGraph generateCCProcessedDependencies(GrammaticalStructure gs, GrammaticalStructure.Extras extras) {
        return SemanticGraphFactory.makeFromTree(gs, Mode.CCPROCESSED, extras, null);
    }

    public static SemanticGraph makeFromTree(Tree tree, Mode mode, GrammaticalStructure.Extras includeExtras, Predicate<TypedDependency> filter, boolean originalDependencies) {
        return SemanticGraphFactory.makeFromTree(tree, mode, includeExtras, filter, originalDependencies, false);
    }

    public static SemanticGraph makeFromTree(Tree tree, Mode mode, GrammaticalStructure.Extras includeExtras, Predicate<TypedDependency> filter, boolean originalDependencies, boolean includePunctuationDependencies) {
        GrammaticalStructure gs;
        if (originalDependencies) {
            Predicate<Object> wordFilt = includePunctuationDependencies ? Filters.acceptFilter() : new PennTreebankLanguagePack().punctuationWordRejectFilter();
            gs = new EnglishGrammaticalStructure(tree, wordFilt, new SemanticHeadFinder(true));
        } else {
            Predicate<Object> tagFilt = includePunctuationDependencies ? Filters.acceptFilter() : new PennTreebankLanguagePack().punctuationTagRejectFilter();
            gs = new UniversalEnglishGrammaticalStructure(tree, tagFilt, new UniversalSemanticHeadFinder(true));
        }
        return SemanticGraphFactory.makeFromTree(gs, mode, includeExtras, filter);
    }

    public static SemanticGraph makeFromTree(GrammaticalStructure gs, Mode mode, GrammaticalStructure.Extras includeExtras, Predicate<TypedDependency> filter) {
        Collection<TypedDependency> deps;
        switch (mode) {
            case ENHANCED: {
                deps = gs.typedDependenciesEnhanced();
                break;
            }
            case ENHANCED_PLUS_PLUS: {
                deps = gs.typedDependenciesEnhancedPlusPlus();
                break;
            }
            case COLLAPSED_TREE: {
                deps = gs.typedDependenciesCollapsedTree();
                break;
            }
            case COLLAPSED: {
                deps = gs.typedDependenciesCollapsed(includeExtras);
                break;
            }
            case CCPROCESSED: {
                deps = gs.typedDependenciesCCprocessed(includeExtras);
                break;
            }
            case BASIC: {
                deps = gs.typedDependencies(includeExtras);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode " + (Object)((Object)mode));
            }
        }
        if (filter != null) {
            ArrayList<TypedDependency> depsFiltered = Generics.newArrayList();
            for (TypedDependency td : deps) {
                if (!filter.test(td)) continue;
                depsFiltered.add(td);
            }
            deps = depsFiltered;
        }
        return new SemanticGraph(deps);
    }

    @Deprecated
    public static SemanticGraph makeFromTree(GrammaticalStructure tree, Mode mode, boolean includeExtras, Predicate<TypedDependency> filter) {
        return SemanticGraphFactory.makeFromTree(tree, mode, includeExtras ? GrammaticalStructure.Extras.MAXIMAL : GrammaticalStructure.Extras.NONE, filter);
    }

    public static SemanticGraph makeFromTree(GrammaticalStructure structure) {
        return SemanticGraphFactory.makeFromTree(structure, Mode.BASIC, GrammaticalStructure.Extras.NONE, null);
    }

    public static SemanticGraph makeFromTree(Tree tree, Mode mode, GrammaticalStructure.Extras includeExtras, Predicate<TypedDependency> filter) {
        return SemanticGraphFactory.makeFromTree(tree, mode, includeExtras, filter, false);
    }

    @Deprecated
    public static SemanticGraph makeFromTree(Tree tree, Mode mode, boolean includeExtras, Predicate<TypedDependency> filter) {
        return SemanticGraphFactory.makeFromTree(tree, mode, includeExtras ? GrammaticalStructure.Extras.MAXIMAL : GrammaticalStructure.Extras.NONE, filter, false);
    }

    public static SemanticGraph makeFromTree(Tree tree, Mode mode, GrammaticalStructure.Extras includeExtras) {
        return SemanticGraphFactory.makeFromTree(tree, mode, includeExtras, null, false);
    }

    @Deprecated
    public static SemanticGraph makeFromTree(Tree tree, Mode mode, boolean includeExtras) {
        return SemanticGraphFactory.makeFromTree(tree, mode, includeExtras ? GrammaticalStructure.Extras.MAXIMAL : GrammaticalStructure.Extras.NONE);
    }

    public static SemanticGraph makeFromEdges(Iterable<SemanticGraphEdge> edges) {
        SemanticGraph sg = new SemanticGraph();
        Set<IndexedWord> vertices = SemanticGraphFactory.getVerticesFromEdgeSet(edges);
        for (IndexedWord vertex : vertices) {
            sg.addVertex(vertex);
        }
        for (SemanticGraphEdge edge : edges) {
            sg.addEdge(edge.getSource(), edge.getTarget(), edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
        sg.resetRoots();
        return sg;
    }

    private static Set<IndexedWord> getVerticesFromEdgeSet(Iterable<SemanticGraphEdge> edges) {
        Set<IndexedWord> retSet = Generics.newHashSet();
        for (SemanticGraphEdge edge : edges) {
            retSet.add(edge.getGovernor());
            retSet.add(edge.getDependent());
        }
        return retSet;
    }

    public static SemanticGraph makeFromVertices(SemanticGraph sg, Collection<IndexedWord> nodes) {
        ArrayList<SemanticGraphEdge> edgesToAdd = new ArrayList<SemanticGraphEdge>();
        ArrayList<IndexedWord> nodesToAdd = new ArrayList<IndexedWord>(nodes);
        for (IndexedWord nodeA : nodes) {
            for (IndexedWord nodeB : nodes) {
                List<SemanticGraphEdge> edges;
                if (nodeA == nodeB || (edges = sg.getShortestDirectedPathEdges(nodeA, nodeB)) == null) continue;
                edgesToAdd.addAll(edges);
                for (SemanticGraphEdge edge : edges) {
                    IndexedWord gov = edge.getGovernor();
                    IndexedWord dep = edge.getDependent();
                    if (gov != null && !nodesToAdd.contains(gov)) {
                        nodesToAdd.add(gov);
                    }
                    if (dep == null || nodesToAdd.contains(dep)) continue;
                    nodesToAdd.add(dep);
                }
            }
        }
        SemanticGraph retSg = new SemanticGraph();
        for (IndexedWord node : nodesToAdd) {
            retSg.addVertex(node);
        }
        for (SemanticGraphEdge edge : edgesToAdd) {
            retSg.addEdge(edge.getGovernor(), edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
        retSg.resetRoots();
        return retSg;
    }

    public static SemanticGraph duplicateKeepNodes(SemanticGraph sg) {
        SemanticGraph retSg = new SemanticGraph();
        for (IndexedWord node : sg.vertexSet()) {
            retSg.addVertex(node);
        }
        retSg.setRoots(sg.getRoots());
        for (SemanticGraphEdge edge : sg.edgeIterable()) {
            retSg.addEdge(edge.getGovernor(), edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
        return retSg;
    }

    public static SemanticGraph makeFromGraphs(Collection<SemanticGraph> sgList) {
        SemanticGraph sg = new SemanticGraph();
        Set<IndexedWord> newRoots = Generics.newHashSet();
        for (SemanticGraph currSg : sgList) {
            newRoots.addAll(currSg.getRoots());
            for (IndexedWord currVertex : currSg.vertexSet()) {
                sg.addVertex(currVertex);
            }
            for (SemanticGraphEdge currEdge : currSg.edgeIterable()) {
                sg.addEdge(currEdge.getGovernor(), currEdge.getDependent(), currEdge.getRelation(), currEdge.getWeight(), currEdge.isExtra());
            }
        }
        sg.setRoots(newRoots);
        return sg;
    }

    public static SemanticGraph deepCopyFromGraphs(List<SemanticGraph> graphs, List<Integer> lengths) {
        SemanticGraph newGraph = new SemanticGraph();
        Map<Integer, IndexedWord> newWords = Generics.newHashMap();
        ArrayList<IndexedWord> newRoots = new ArrayList<IndexedWord>();
        int vertexOffset = 0;
        for (int i = 0; i < graphs.size(); ++i) {
            SemanticGraph graph = graphs.get(i);
            for (IndexedWord vertex : graph.vertexSet()) {
                IndexedWord newVertex = new IndexedWord(vertex);
                newVertex.setIndex(vertex.index() + vertexOffset);
                newGraph.addVertex(newVertex);
                newWords.put(newVertex.index(), newVertex);
            }
            for (SemanticGraphEdge edge : graph.edgeIterable()) {
                IndexedWord gov = (IndexedWord)newWords.get(edge.getGovernor().index() + vertexOffset);
                IndexedWord dep = (IndexedWord)newWords.get(edge.getDependent().index() + vertexOffset);
                if (gov == null || dep == null) {
                    throw new AssertionError((Object)"Counting problem (or broken edge)");
                }
                newGraph.addEdge(gov, dep, edge.getRelation(), edge.getWeight(), edge.isExtra());
            }
            for (IndexedWord root : graph.getRoots()) {
                newRoots.add((IndexedWord)newWords.get(root.index() + vertexOffset));
            }
            vertexOffset += lengths.get(i).intValue();
        }
        newGraph.setRoots(newRoots);
        return newGraph;
    }

    public static enum Mode {
        COLLAPSED_TREE,
        COLLAPSED,
        CCPROCESSED,
        BASIC,
        ENHANCED,
        ENHANCED_PLUS_PLUS;

    }
}

