/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;

public class WordStemmer
implements TreeVisitor {
    @Override
    public void visitTree(Tree t) {
        WordStemmer.processTree(t, null, new Morphology());
    }

    private static void processTree(Tree t, String tag, Morphology morpha) {
        if (t.isPreTerminal()) {
            tag = t.label().value();
        }
        if (t.isLeaf()) {
            t.label().setValue(morpha.lemma(t.label().value(), tag));
        } else {
            for (Tree kid : t.children()) {
                WordStemmer.processTree(kid, tag, morpha);
            }
        }
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        treebank.loadPath(args[0]);
        WordStemmer ls = new WordStemmer();
        for (Tree tree : treebank) {
            ls.visitTree(tree);
            System.out.println(tree);
        }
    }
}

