1. Data Source:

The higgs dataset is available at https://archive.ics.uci.edu/ml/machine-learning-databases/00280/.

The pokerhand dataset is available at https://archive.ics.uci.edu/ml/machine-learning-databases/poker/.



2. Code Summary:

(i) Modules

- system.py
Realizes our proposed AD-OGP and its two variants without instantanous model averaging and asymmetric gossiping communication. 

- data.py
Loads in data stream and preprocesses the instances.

- network.py
Generates different types of network.

- event.py
Simulates timeline and different types of delays.

- my_utils.py
Realizes logistic loss and multivariate logistic loss.

(ii) Test Files 

(Before running, you should set the ``data_folder`` and ``save_folder`` variables in each file to be the paths of source data and experimental results.)

- ph_perf.py
Verifies the benefit of asynchronicity (on pokerhand).

- ph_instantMA.py
Verifies the effectiveness of instantaneous model averaging (on pokerhand).

- ph_asymcommu.py
Verifies the effecitveness of asymmetric gossiping communication (on pokerhand).



