import numpy as np

class Logit(object):
    CLIP = 40
    
    @classmethod
    def _h(cls, weight, feature, label):
        decision = np.clip(np.dot(weight, feature), -cls.CLIP, cls.CLIP)
        return (1.0 + np.exp(-decision * label)) ** -1
    
    @classmethod
    def loss(cls, weight, feature, label):
        assert(label == 1 or label == -1), 'Invalid Label %s'%(label)
        return -np.log(cls._h(weight, feature, label))
    
    @classmethod
    def gradient(cls, weight, feature, label):
        return (cls._h(weight, feature, label) - 1) * label * feature

class MultiLogit(object):
    CLIP = 40
    
    @classmethod
    def _h(cls, weight, feature):
        decision = np.clip(np.dot(weight, feature), -cls.CLIP, cls.CLIP)
        hh = np.exp(decision)
        return hh/np.sum(hh)
    
    @classmethod
    def loss(cls, weight, feature, label):
        h = cls._h(weight, feature)
        return -np.log(h[label])
    
    @classmethod
    def gradient(cls, weight, feature, label):
        h = cls._h(weight, feature)
        h[label] -= 1
        return np.outer(h, feature)
