import random
import networkx as nx

def bipartite_graph_matching_with_tolerance(m, n, l, r, q):
    # if m * l != n * r:
    #     raise ValueError("ml must equal nr for a valid bipartite graph matching.")
    # print(m,n,l,r)
    while True:
        G = nx.Graph()
        left_nodes = [f"L{i}" for i in range(m)]
        right_nodes = [f"R{i}" for i in range(n)]

        G.add_nodes_from(left_nodes, bipartite=0)
        G.add_nodes_from(right_nodes, bipartite=1)

        edges = []
        for left in left_nodes:
            connections = random.sample(right_nodes, l)
            for right in connections:
                edges.append((left, right))

        random.shuffle(edges)  # Ensure sufficient randomization
        G.add_edges_from(edges[:m * l])  # Add only the required number of edges

        # Verify degree constraints with tolerance
        valid = True
        for node in left_nodes:
            if abs(G.degree(node) - l) > q:
                valid = False
                break
        for node in right_nodes:
            if abs(G.degree(node) - r) > q:
                valid = False
                break

        if valid:
            return G

# # Example usage
# m, n, l, r, q = 5, 10, 2, 1, 1
# bipartite_graph = bipartite_graph_matching_with_tolerance(m, n, l, r, q)