import matplotlib.pyplot as plt
import numpy as np
import os

path = "bp_results.txt"

results = {}
methods = ["MV", "KOS", "BP"]

with open(path, "r") as fr:
    lines = fr.readlines()
    method = ""
    for line in lines:
        words = line.strip().split(":")
        if words[0] in methods:
            method = words[0]
            results[method] = [[], [], []]
        elif words[0] == "budget_ratio":
            ratio = float(words[1].strip())
            results[method][0].append(ratio)
        elif words[0] == "1-stage":
            acc = float(words[2].strip())
            results[method][1].append(acc)
        elif words[0] == "2-stage":
            acc = float(words[2].strip())
            results[method][2].append(acc)

for method in methods:
    ratios = results[method][0]
    stage1_acc = results[method][1]
    stage2_acc = results[method][2]

    # Sort ratios and corresponding accuracies in ascending order of ratios
    sorted_data = sorted(zip(ratios, stage1_acc, stage2_acc), key=lambda x: x[0])
    ratios, stage1_acc, stage2_acc = zip(*sorted_data)

    x = np.arange(len(ratios))  # the label locations
    width = 0.35  # the width of the bars

    fig, ax = plt.subplots()
    rects1 = ax.bar(x - width/2, stage1_acc, width, label='1-stage')
    rects2 = ax.bar(x + width/2, stage2_acc, width, label='2-stage')

    # Add some text for labels, title and custom x-axis tick labels, etc.
    ax.set_xlabel('Budget')
    ax.set_ylabel('Accuracy')
    ax.set_title(f'Comparison of 1-stage and 2-stage for {method}')
    ax.set_xticks(x)
    ax.set_xticklabels([f"{r:.2f}" for r in ratios])
    ax.legend()

    fig.tight_layout()
    plt.savefig(f"{method}_bp.png")
    plt.show()