import numpy as np
import random
# from scipy.stats import beta
import networkx as nx

class Paper():
    def __init__(self, id, quality):
        self.quality = quality
        self.id = id
        self.reviews = []

class Review():
    def __init__(self, id, reviewer, paper):
        self.id = id
        self.paper = paper
        self.reviewer = reviewer
        self.reports = []
    
    def _operate(self):
        eps = random.random()
        if eps < self.reviewer.reliability:
            self.rating = self.paper.quality
        else:
            self.rating = -self.paper.quality

class Report():
    def __init__(self, id, reporter, review):
        self.id = id
        self.reporter = reporter
        self.review = review
    
    def _operate(self):
        eps = random.random()
        grt = self.review.rating * self.review.paper.quality
        eps = random.random()
        if eps < self.reporter.reliability:
            self.rating = grt
        else:
            self.rating = -grt

class Reviewer():
    def __init__(self, id, reliability):
        self.id = id
        self.reliability = reliability
        self.reviews = []
        self.reports = []
        
    
class conference():
    def __init__(self, paper_num, reviewer_num, reviewer_prior, reviewer_workload, review_per_paper, report_per_review):
        self.paper_num = paper_num
        self.reviewer_num = reviewer_num
        self.reviewer_prior = reviewer_prior
        self.review_per_paper = review_per_paper
        self.report_per_review = report_per_review
        self.reviewer_workload = reviewer_workload


    def generate1(self):
        papers_quality = np.array([-1 for _ in range(self.paper_num)])
        accept_indices = random.sample([i for i in range(self.paper_num)], self.paper_num//2)
        papers_quality[accept_indices] = 1

        self.papers = []
        paper_id = 0
        for paperq in papers_quality:
            self.papers.append(Paper(paper_id, paperq))
            paper_id += 1
        
        reviewers_reliability = np.array([self.reviewer_prior[2] for _ in range(self.reviewer_num)])
        expert_indices = random.sample([i for i in range(self.reviewer_num)], int(self.reviewer_num * self.reviewer_prior[1]))
        reviewers_reliability[expert_indices] = self.reviewer_prior[0]

        self.reviewers = []
        id = 0
        for reviewerr in reviewers_reliability:
            self.reviewers.append(Reviewer(id, reviewerr))
            id += 1
        
        # print(len(self.reviewers))
    
    # def beta_reviewers_generate(self, author_dis, review_dis, report_dis):
    #     # Assuming reviewers sampled from beta(2,2)
    #     for i in range(self.Author_num):
    #         new_alpha = report_dis[0]
    #         new_beta = report_dis[1]
    #         author_eps = random.random()
    #         for j in range(len(author_dis[0])):
    #             if author_eps <= author_dis[0][j]:
    #                 new_quality = author_dis[1][j]
    #                 break                
    #         new_author = Author(i, (new_alpha, new_beta), new_quality, self.paper_per_author)
    #         self.Authors.append(new_author)
    #     for i in range(self.reviewer_num):
    #         review_eps = random.random()
    #         new_review = beta.ppf(review_eps, review_dis[0], review_dis[1])
    #         new_reviewer = Reviewer(i, new_review)
    #         self.Reviewers.append(new_reviewer)

    #     for i in range(self.Author_num):
    #         self.Papers.extend(self.Authors[i].papers)

    def reset(self):
        self.reviewers = []
        self.papers = []
        self.reviews = []
        self.reports = []
        
    # def assign(self):
    #     # Assigning papers
    #     reviewer_load = [int(self.Author_num*self.paper_per_author*self.review_per_paper/self.reviewer_num) for _ in range(self.reviewer_num)]
    #     available_reviewers = [i for i in range(self.reviewer_num)]
    #     for author in self.Authors:
    #         for paper in author.papers:
    #             available_reviewers.sort(key=lambda x: reviewer_load[x], reverse=True)
    #             reviewers = available_reviewers[:self.review_per_paper]
    #             for r in reviewers:
    #                 self.Reviewers[r].assigned.append(paper)
    #                 reviewer_load[r] -= 1
    #                 if reviewer_load[r] <= 0:
    #                     available_reviewers.remove(r)
        
    def assign_direct(self):
        # Assigning papers
        reviewer_load = [self.reviewer_workload for i in range(self.reviewer_num)]
        available_reviewers = self.reviewers.copy()
        occupied_reviewers = []
        
        for paper in self.papers:
            if len(available_reviewers) >= self.review_per_paper: # Enough reviewers
                reviewers = random.sample(available_reviewers, self.review_per_paper)
                for r in reviewers:
                    new_review = Review(len(self.reviews), r, paper)
                    r.reviews.append(new_review)
                    self.reviews.append(new_review)
                    paper.reviews.append(new_review)
                    reviewer_load[r.id] -= 1
                    if reviewer_load[r.id] <= 0:
                        available_reviewers.remove(r)
                        occupied_reviewers.append(r)
            else:
                reviewers = [r for r in available_reviewers]
                for r in reviewers:
                    new_review = Review(len(self.reviews), r, paper)
                    r.reviews.append(new_review)
                    self.reviews.append(new_review)
                    paper.reviews.append(new_review)
                    reviewer_load[r.id] -= 1
                    if reviewer_load[r.id] <= 0:
                        available_reviewers.remove(r)
                        occupied_reviewers.append(r)
                while len(reviewers) < self.review_per_paper:
                    new_reviewer = random.choice(occupied_reviewers)
                    while new_reviewer in [review.reviewer for review in paper.reviews]: # Need to find a reviewer who hasn't reviewed this paper
                        new_reviewer = random.choice(occupied_reviewers)
                    for swap_paper in [review.paper for review in new_reviewer.reviews]:
                        for vaccant_reviewer in available_reviewers:
                            if vaccant_reviewer not in [review.reviewer for review in swap_paper.reviews]:
                                for review in new_reviewer.reviews:
                                    if review.paper == swap_paper:
                                        new_reviewer.reviews.remove(review)
                                        swap_paper.reviews.remove(review)
                                        self.reviews.remove(review)
                                        swap_id = review.id
                                        break
                                
                                new_review = Review(swap_id, vaccant_reviewer, swap_paper)
                                vaccant_reviewer.reviews.append(new_review)
                                swap_paper.reviews.append(new_review)
                                self.reviews.append(new_review)
                                reviewers.append(vaccant_reviewer)
                                reviewer_load[vaccant_reviewer.id] -= 1
                                if reviewer_load[vaccant_reviewer.id] <= 0:
                                    available_reviewers.remove(vaccant_reviewer)
                                    occupied_reviewers.append(vaccant_reviewer)
                                break
                        break
    
    def assign_succ(self):
        
        reviewer_load = [self.reviewer_workload for i in range(self.reviewer_num)]
        available_reviewers = self.reviewers.copy()[:len(self.reviewers)//2]
        occupied_reviewers = []
        
        for paper in self.papers:
            if len(available_reviewers) >= self.review_per_paper//2: # Enough reviewers
                reviewers = random.sample(available_reviewers, self.review_per_paper//2)
                for r in reviewers:
                    new_review = Review(len(self.reviews), r, paper)
                    r.reviews.append(new_review)
                    self.reviews.append(new_review)
                    paper.reviews.append(new_review)
                    reviewer_load[r.id] -= 1
                    if reviewer_load[r.id] <= 0:
                        available_reviewers.remove(r)
                        occupied_reviewers.append(r)
            else:
                reviewers = [r for r in available_reviewers]
                for r in reviewers:
                    new_review = Review(len(self.reviews), r, paper)
                    r.reviews.append(new_review)
                    self.reviews.append(new_review)
                    paper.reviews.append(new_review)
                    reviewer_load[r.id] -= 1
                    if reviewer_load[r.id] <= 0:
                        available_reviewers.remove(r)
                        occupied_reviewers.append(r)
                while len(reviewers) < self.review_per_paper//2:
                    new_reviewer = random.choice(occupied_reviewers)
                    while new_reviewer in [review.reviewer for review in paper.reviews]: # Need to find a reviewer who hasn't reviewed this paper
                        new_reviewer = random.choice(occupied_reviewers)
                    for swap_paper in [review.paper for review in new_reviewer.reviews]:
                        for vaccant_reviewer in available_reviewers:
                            if vaccant_reviewer not in [review.reviewer for review in swap_paper.reviews]:
                                for review in new_reviewer.reviews:
                                    if review.paper == swap_paper:
                                        new_reviewer.reviews.remove(review)
                                        swap_paper.reviews.remove(review)
                                        self.reviews.remove(review)
                                        swap_id = review.id
                                        break
                                
                                new_review = Review(swap_id, vaccant_reviewer, swap_paper)
                                vaccant_reviewer.reviews.append(new_review)
                                swap_paper.reviews.append(new_review)
                                self.reviews.append(new_review)
                                reviewers.append(vaccant_reviewer)
                                reviewer_load[vaccant_reviewer.id] -= 1
                                if reviewer_load[vaccant_reviewer.id] <= 0:
                                    available_reviewers.remove(vaccant_reviewer)
                                    occupied_reviewers.append(vaccant_reviewer)
                                break
                        break
        for reviewer in self.reviewers[len(self.reviewers)//2:]:
            corr_reviewer = self.reviewers[reviewer.id - len(self.reviewers)//2]
            for review in corr_reviewer.reviews:
                new_report = Report(len(self.reports), reviewer, review)
                reviewer.reports.append(new_report)
                review.reports.append(new_report)
                self.reports.append(new_report)
        
    
    def work(self):
        for review in self.reviews:
            review._operate()
        for report in self.reports:
            report._operate()
    
    def make_matrix_direct(self):
        A = np.zeros((len(self.papers), self.reviewer_num), dtype=int)
        for i in range(self.reviewer_num):
            reviewer = self.reviewers[i]
            for j in range(len(reviewer.reviews)):
                review = reviewer.reviews[j]
                paper = review.paper
                A[paper.id, i] = review.rating    
        return A


    def make_matrices_succ(self):
        A1 = np.zeros((len(self.papers), self.reviewer_num//2), dtype=int)
        for i in range(self.reviewer_num):
            reviewer = self.reviewers[i]
            for j in range(len(reviewer.reviews)):
                review = reviewer.reviews[j]
                paper = review.paper
                A1[paper.id, i] = review.rating       
        A2 = np.zeros((self.reviewer_num//2, len(self.papers)), dtype=int)
        for i in range(len(self.reviews)):
            review = self.reviews[i]
            for report in review.reports: 
                A2[review.reviewer.id, review.paper.id] = report.rating
        return A1, A2
    
    def _find_minimum_cycle(self, G):
        # 使用 networkx 中的 cycle_basis 找到所有圈 
        cycles = nx.cycle_basis(G)  
        if cycles:  
        # 找到最小循环 
            min_cycle = min(cycles, key=len)  
           
    
    def check_assignment(self):
        edges = []
        for i in range(len(self.papers)):
            paper = self.papers[i]
            for review in paper.reviews:
                edges.append((paper.id, review.reviewer.id+len(self.papers)))
        
        G = nx.Graph()   
        G.add_edges_from(edges)  

        cycles = nx.cycle_basis(G)
        if cycles:
            min_cycle = min(cycles, key=len)
            cycle_num = len(cycles)
            total_len = 0
            for cycle in cycles:
                total_len += len(cycle)
            cycles.sort(key=len)
            ave_len = total_len / cycle_num
            print("min_cycle_len: ", len(min_cycle))
            print("cycle_num: ", cycle_num)
            print("ave_cycle_len", ave_len)
            print("0.7len", len(cycles[cycle_num*7//10]))
        else:  
            print("No cycle detected")