import os
from openai import OpenAI
os.environ["OPENAI_API_KEY"] = "" # Input your key here
client = OpenAI()

def generate_from_thinker(prompts, max_tokens, model="gpt-4-1106-preview", temperature=0.7, n=1):
    """
    """
    message = prompts[0]["content"]
    assistant = client.beta.assistants.create(
        model=model,
        instructions="""You are a thinker. I need you to help me think about some problems.
        You need to provide me the answer based on the format of the example.""",
        name="Thinker",
        tools=[{"type": "code_interpreter"}],
    )

    thread = client.beta.threads.create()

    thread_message = client.beta.threads.messages.create(
        thread_id=thread.id,
        role="user",
        content=message,
    )
    
    run = client.beta.threads.runs.create(
        thread_id=thread.id,
        assistant_id=assistant.id,
    )  

    while run.status in ["queued", "in_progress"]:
        keep_retrieving_run = client.beta.threads.runs.retrieve(
            thread_id=thread.id,
            run_id=run.id
        )

        if keep_retrieving_run.status == "completed":
            print("\n")

            # Step 6: Retrieve the Messages added by the Assistant to the Thread
            all_messages = client.beta.threads.messages.list(
                thread_id=thread.id
            )
            
            # Check the code part
            run_steps = client.beta.threads.runs.steps.list(
                thread_id=thread.id,
                run_id=run.id
            )
            # print("run_steps",run_steps)
            
            # Check other informations
            # print("------------------------------------------------------------ \n")
            # print(f"all messages:{all_messages}")
            # print(f"User: {thread_message.content[0].text.value}")
            # print(f"Assistant: {all_messages.data[0].content[0].text.value}")
            
            Assistant_response = all_messages.data[0].content[0].text.value
            # print(f"Assistant: {Assistant_response}")
            return Assistant_response

        elif keep_retrieving_run.status == "queued" or keep_retrieving_run.status == "in_progress":
            pass
        else:
            print(f"Run status: {keep_retrieving_run.status}")
            break
        

def generate_from_judge(prompts, max_tokens, model="gpt-4-1106-preview", temperature=0.7, n=1):
    """
    """
    message = prompts[0]["content"]
    assistant = client.beta.assistants.create(
        model=model,
        instructions="""You're a judge. I need you to make judgments on some statements.
        You are only allowed to use the "True" or "False" as the final answer.""",
        name="Judge",
        tools=[{"type": "code_interpreter"}],
    )

    thread = client.beta.threads.create()

    thread_message = client.beta.threads.messages.create(
        thread_id=thread.id,
        role="user",
        content=message,
    )
    
    run = client.beta.threads.runs.create(
        thread_id=thread.id,
        assistant_id=assistant.id,
    )  

    while run.status in ["queued", "in_progress"]:
        keep_retrieving_run = client.beta.threads.runs.retrieve(
            thread_id=thread.id,
            run_id=run.id
        )
        
        if keep_retrieving_run.status == "completed":
            print("\n")

            all_messages = client.beta.threads.messages.list(
                thread_id=thread.id
            )
            
            # # Check the code part
            # run_steps = client.beta.threads.runs.steps.list(
            #     thread_id=thread.id,
            #     run_id=run.id
            # )
            # print("run_steps",run_steps)            

            # Check other informations
            # print("------------------------------------------------------------ \n")
            # print(f"all messages:{all_messages}")
            # print(f"User: {thread_message.content[0].text.value}")
            # print(f"Assistant: {all_messages.data[0].content[0].text.value}")
            
            Assistant_response = all_messages.data[0].content[0].text.value
            # print(f"Assistant: {Assistant_response}")
            return Assistant_response

        elif keep_retrieving_run.status == "queued" or keep_retrieving_run.status == "in_progress":
            pass
        else:
            print(f"Run status: {keep_retrieving_run.status}")
            break


def generate_from_excutor(prompts, max_tokens, model="gpt-4-1106-preview", temperature=0.7, n=1):
    """
    """
    message = prompts[0]["content"]
    assistant = client.beta.assistants.create(
        model=model,
        instructions="""You're an excutor. I need you to calculate the final result based on some conditions and steps.
        You need to provide me the answer based on the format of the examples.""",
        name="Excutor",
        tools=[{"type": "code_interpreter"}],
    )

    thread = client.beta.threads.create()

    thread_message = client.beta.threads.messages.create(
        thread_id=thread.id,
        role="user",
        content=message,
    )
    
    run = client.beta.threads.runs.create(
        thread_id=thread.id,
        assistant_id=assistant.id,
    )  

    while run.status in ["queued", "in_progress"]:
        keep_retrieving_run = client.beta.threads.runs.retrieve(
            thread_id=thread.id,
            run_id=run.id
        )

        if keep_retrieving_run.status == "completed":
            print("\n")

            # Step 6: Retrieve the Messages added by the Assistant to the Thread
            all_messages = client.beta.threads.messages.list(
                thread_id=thread.id
            )
            
            # Check the code part 
            # run_steps = client.beta.threads.runs.steps.list(
            #     thread_id=thread.id,
            #     run_id=run.id
            # )
            # print("run_steps",run_steps)   
            
            # Check other informations
            # print("------------------------------------------------------------ \n")
            # print(f"all messages:{all_messages}")
            # print(f"User: {thread_message.content[0].text.value}")
            # print(f"Assistant: {all_messages.data[0].content[0].text.value}")
            try:
                Assistant_response = all_messages.data[0].content[0].text.value
            except AttributeError:
                Assistant_response = all_messages.data[0].content[1].text.value
            # print(f"Assistant: {Assistant_response}")
            return Assistant_response

        elif keep_retrieving_run.status == "queued" or keep_retrieving_run.status == "in_progress":
            pass
        else:
            print(f"Run status: {keep_retrieving_run.status}")
            break