import warnings
from .vdd_utils import get_vdd_data
from .five_dataset_utils import get_5datasets_data
from .imagenet_utils import get_imagenet_data


def create_dataset_v2(
    benchmark,
    data_root, 
    task_names,
    task_idx=None,
    load_single_task=False,
    imagenet_root=None, 
    cache=True, 
    cache_root=None,
    dev_percent=0.1, 
    offset_task_labels=False, 
    scenario="class-incremental", 
    vdd_root=None, 
    **kwargs
):

    if imagenet_root is not None:
        warnings.warn("imagenet_root has been deprecated. Use vdd_root instead.")
        if vdd_root is None:
            vdd_root = imagenet_root

    if benchmark == "vdd":
        datasets = get_vdd_data(data_root, task_names, task_idx=task_idx, load_single_task=load_single_task, cache=cache, dev_percent=dev_percent, offset_task_labels=offset_task_labels, scenario=scenario)
    elif benchmark == "5-datasets":
        datasets = get_5datasets_data(vdd_root, data_root, task_names, task_idx=task_idx, load_single_task=load_single_task, cache=cache, cache_root=cache_root, dev_percent=dev_percent, offset_task_labels=offset_task_labels, scenario=scenario)
    elif benchmark == "imagenet":
        datasets = get_imagenet_data(data_root, dev_percent=dev_percent, offset_task_labels=offset_task_labels, **kwargs)
    else:
        raise ValueError(f"Benchmark {benchmark} not supported.")

    return datasets
