def conditional_forward(backbone_forward):

    def expert_forward(self, *inputs):

        module_inputs, forward_modifiers = inputs

        assert isinstance(module_inputs, tuple), "Module inputs must be a tuple"
    
        execute_op = forward_modifiers.get("execute_op", None)
        if execute_op is None:
            raise ValueError("execute_op not found in forward_modifiers")
        
        if execute_op:
            x = backbone_forward(self, *module_inputs)
        else:
            x = module_inputs[0] if len(module_inputs) == 1 else module_inputs
        return x

    return expert_forward
