#!/bin/bash

# if [ $# -lt 4 ]
#     then
#         echo "The script should be invoked as ./run.sh <DATA_ROOT> <BACKBONE> <CHEEM_COMPONENT> <CUDA_VISIBLE_DEVICE>"
#         exit 1
# fi

# if [ $# -gt 4 ]
#     then
#         echo "The script should be invoked as ./run.sh <DATA_ROOT> <BACKBONE> <CHEEM_COMPONENT> <CUDA_VISIBLE_DEVICE>"
#         exit 1
# fi

# https://stackoverflow.com/questions/242538/unix-shell-script-find-out-which-directory-the-script-file-resides
# Absolute path to this script
SCRIPT=$(readlink -f "$0")
SCRIPT_DIR=$(dirname "$SCRIPT")
CHEEM_DIR="$SCRIPT_DIR/../.."
TIMM_DIR="$CHEEM_DIR/external/pytorch-image-models"

export PYTHONPATH="$PYTHONPATH:$TIMM_DIR:$CHEEM_DIR"
# export CUDA_VISIBLE_DEVICES=$4
export CUDA_VISIBLE_DEVICES=9

ROOT_DIR="$CHEEM_DIR"

# Backbone
# BACKBONE=$2
# CHEEM_COMPONENT=$3
BACKBONE=vit_base_patch8_224

# Benchmark
BENCHMARK=vdd
NUM_TASKS=10
BENCHMARK_CONFIG_FILE="$ROOT_DIR/configs/$BENCHMARK/${BACKBONE}.yaml"
# DATA_ROOT=$1
DATA_ROOT=./data/vdd

EPOCHS=$1
SAMPLING_SCHEME=$2
SEED=$3
SEQ=$4
CHEEM_COMPONENT=$5

WANDB_PROJECT=null
WANDB_USERNAME=null
# EXP_NAME=_improved-sampling-agnostic-$CHEEM_COMPONENT-$SEED
# EXP_NAME=next-gen-cheem-$SEED-$CHEEM_COMPONENT
# EXP_NAME=exp-agnostic-$SEED-$CHEEM_COMPONENT
# EXP_NAME=long-run-cheem-inc50-$SEED-$CHEEM_COMPONENT
# EXP_NAME=neurips-$CHEEM_COMPONENT-$SEED-$SAMPLING_SCHEME-$EPOCHS
EXP_NAME=$CHEEM_COMPONENT-$SAMPLING_SCHEME-$EPOCHS-$SEED

python3 $SCRIPT_DIR/visualize.py --root_dir $ROOT_DIR --benchmark $BENCHMARK --runtime-config-file $BENCHMARK_CONFIG_FILE \
        --wandb-project $WANDB_PROJECT --wandb-username $WANDB_USERNAME --exp-name $EXP_NAME \
        --task-idx 9 --seed $SEED --epochs $EPOCHS --sampling_scheme $SAMPLING_SCHEME --seq $SEQ \
        --cheem-component $CHEEM_COMPONENT
