# MaD-Scientist: AI-based Scientist solving Convection-Diffusion-Reaction Equations Using Massive PINN-Based Prior Data

## Setup Requirements

First, clone this git repository to your workspace.
You can setup the environment with following command:

```setup
conda env update -f env.yaml
```
## Generate Dataset
In order to train the Transformer, we have to generate the dataset of intereset.
```generate_dataset
cd data_gen
chmod +x generate_dataset.sh
```
In `generate_dataset.sh` script file, 
1) adjust the initial condition using `--u0_str` option,
2) adjust the range of five given parameters with `--beta_min`, `--beta_max`, `--beta_step`, and so on,
3) choose whether to generate numerical solution or PINN-Prior by adjusting `--numerical`,
4) choose whether to generate extrapolating dataset by adjusting `--extrapolation`.
refer to the pre-written example code.

After running this script file, the dataset is properly generated at ./data_gen/dataset directory.

## Training Process

The training process is performed using the script located at `./train.py`. To start the training, execute the `train_reaction_Fisher.sh` script in the `./script` directory.

### Steps

1. Navigate to the shell directory and make the script executable: 

```train_navigate
   cd shell
   chmod +x train_reaction_Fisher.sh
```
2. Before running the script, ensure that your GPU is available. If another method is required to activate the GPU device, modify the `.sh` file accordingly. 
Once the GPU is properly set up, run the following command.
  
```execution
  ./train_reaction_Fisher.sh
```


### Important Notes

1. Dataset Requirement:
The execution will stop if the required dataset is not found. Make sure the dataset is prepared in advance.
2. Model Checkpoints:
If the training completes successfully, the parameter file (`.pt`) will be saved in the `./parameter` directory every 1000 epochs.

## Test Model

The training process is performed using the script located at `./train.py`. To start the testing, execute the `test.sh` script in the `./script` directory.
```test_navigate
   cd shell
   chmod +x test.sh
```

