import argparse

parser = argparse.ArgumentParser()

# Device
parser.add_argument('--device', type=str, default='cuda')

# System
parser.add_argument('--system', type=str, default='reaction')
parser.add_argument('--seed', type=int, default=0)

# Choose numerical data or generating with PINN.
parser.add_argument('--numerical', type=int, default=1)

# Domain information.
parser.add_argument('--xgrid', type=int, default=256)
parser.add_argument('--nt', type=int, default=100)

# Inject noise or not.
parser.add_argument('--noise', type=int, default=0)
parser.add_argument('--noise_rate', type=int, default=5)

# Choose an extrapolation setting.
parser.add_argument('--extrapolation', type=int, default=0)

# Train epoch.
parser.add_argument('--epoch', type=int, default=4000)
parser.add_argument('--PINN_epoch', type=int, default=20000)

# PINN control.
parser.add_argument('--threshold', type=float, default = 10e-4)

# Choose the percentage ratio of (PINN_based_prior).
parser.add_argument('--PINN_based_prior_ratio', type=int, default = 0)

# Plot the result.
parser.add_argument('--plot', type=int, default=0)

parser.add_argument('--is_2D', type=int, default=0)

parser.add_argument('--u0_str', default='1+sin(x)')

parser.add_argument('--beta_min', type=float, default = 0.0)
parser.add_argument('--nu_min', type=float, default = 0.0)
parser.add_argument('--rho_min', type=float, default = 0.0)
parser.add_argument('--epsilon_min', type=float, default = 0.0)
parser.add_argument('--theta_min', type=float, default = 0.0)

parser.add_argument('--beta_max', type=float, default = 0.0)
parser.add_argument('--nu_max', type=float, default = 0.0)
parser.add_argument('--rho_max', type=float, default = 0.0)
parser.add_argument('--epsilon_max', type=float, default = 0.0)
parser.add_argument('--theta_max', type=float, default = 0.0)

parser.add_argument('--beta_step', type=int, default=1)
parser.add_argument('--nu_step', type=int, default=1)
parser.add_argument('--rho_step', type=int, default=1)
parser.add_argument('--epsilon_step', type=int, default=1)
parser.add_argument('--theta_step', type=int, default=1)

def get_config():
    return parser.parse_args()