# -*- encoding: utf-8 -*-
"""
@File    :   log.py
@Time    :   2023/12/27 20:45:12
@Author  :   yxing
"""

import os
import sys
import pytz
from datetime import datetime

class Logger:
    def __init__(self, log_path, log_file='log.txt'):
        if not os.path.exists(log_path):
            os.makedirs(log_path)

        self._log_dest = os.path.join(log_path, log_file)
        assert not os.path.isdir(self._log_dest), 'The logging file is now a directory!'
        if os.path.exists(self._log_dest):
            usr_response = input(f"{self._log_dest} already exist. Do you want to cover it? Y/N\n")
            if usr_response.lower() == 'y':
                open(self._log_dest, 'w').close()
            elif usr_response.lower() == 'n':
                sys.exit('Please specify another logging path.')
            else:
                raise ValueError('Wrong input. Only accepts Y/N.')        

    def log(self, obj):
        time = datetime.now(pytz.timezone('Asia/Shanghai')).strftime('%b-%d_%H:%M:%S')
        obj = '[{}]  {}'.format(time, obj)
        print(obj)
        with open(self._log_dest, 'a') as f:
            print(obj, file=f)