from datetime import datetime
import pytz

class Timer:
    def __init__(self, zone, form):
        self.zone = zone
        self.form = form

        self.prev_t = 0 # the time when call now()
        self.elapsed_t = 0 # the time elapsed after last call of now()

    def now(self):
        t = datetime.now(pytz.timezone(self.zone)).strftime(self.form)
        self.elapsed_t = t - self.prev_t
        self.prev_t = t
        return t