param(
    [ValidateSet("Jq", "Python")][string]$language,
    [string]$model,
    [switch]$implicit = $false,
    [string]$debug = ""
)

$debugArg = ""
if ($debug -ne "") { 
    if ($debug -eq "auto") {
        $debug = "bbc_channels.182"
    }
    $debugArg = "--select '$debug' --verbosity Debug"
}

$sol = "$language" + "Agent"
$dir = "E:/Papers/jqBench"
$cmd = @(
    'python'
    'inference\solve.py'
    "--benchmarks $dir/data/spider/4_compiled/spider.json"
    '--input.kind Schema'
    "--solver $sol"
    "--solver.implicit $implicit"
    # model
    "--model.name $model"
    '--cache auto'
    "--cache-root $dir/caches/solve"
    # output
    '--output auto'
    "--output-root $dir/results"
    $debugArg
) -join ' '

Invoke-Expression $cmd