from pathlib import Path
from typing import Union
from pydantic import BaseModel, RootModel, Field


class Column(BaseModel):
    name: str
    type: str


class Table(BaseModel):
    name: str
    columns: list[Column]
    foreignKeys: dict[str, str]
    rows: list[dict[str, Union[str, int, float, None]]]


class Database(RootModel):
    root: dict[str, Table] = Field(default_factory=dict)


def get_root() -> Path:
    cur = Path(__file__).resolve()
    prv = None
    while cur != prv:
        if (cur / "setup.ps1").exists():
            return cur
        prv = cur
        cur = cur.parent
    return Path(__file__).resolve().parent.parent.parent
