param(
    [Parameter()][int]$begin = 1,
    [Parameter()][int]$end = 69,
    [string]$model = "Gpt41",
    [switch]$parallel
)

if ($parallel) {
    $begin..$end | ForEach-Object { $_ } | .\rust-parallel.exe -j8 -p python .\data_generation\stackoverflow_\3_convert.py --model $model --iterations 32 --page
}
else {
    for ($i = $begin; $i -le $end; $i++) {
        python .\data_generation\stackoverflow_\3_convert.py --model $model --iterations 32 --page $i
    }
}
