param(
    [switch]$debug = $false,
    [string]$model = "Gpt41",
    [int]$workers = 4
)

# Optional debug selection argument (added feature, does not alter default semantics)
$debugArg = ""
if ($debug) {
    $debugArg = "--select 25414854"
}

# Base directory
$dir = "E:/Papers/jqBench"

# Build command preserving original arguments/semantics
$cmd = @(
    'python'
    'inference\solve.py'
    "--benchmarks $dir/data/stackoverflow/4_collected/stackoverflowValid.json"
    '--input.kind InputOutput'
    '--input.which AllButOne'
    "--model.name $model"
    '--solver JqSampler'
    '--cache auto'
    "--cache-root $dir/caches/solve"
    '--output auto'
    "--output-root $dir/results"
    "--workers $workers"
    $debugArg
) -join ' '

Invoke-Expression $cmd