param(
    [ValidateSet("Jq", "Python")][string]$language,
    [ValidateSet("Examples", "InputOutput")][string]$kind = "InputOutput",
    [string]$model,
    [switch]$documentation = $false,
    [switch]$implicit = $false,
    [switch]$write = $false,
    [switch]$debug = $false,
    [int]$iterations = 8
)

$debugArg = ""
if ($debug) { 
    $debugArg = "--select 25414854"
}

$extraArgs = ""
if ($documentation) {
    if ($language -eq "Jq") {
        $extraArgs = "--solver.documentation True"
    }
    else {
        throw "Documentation is only supported for Jq."
    }
}

$sol = "$language" + "Agent"
$dir = "E:/Papers/jqBench"
$cmd = @(
    'python'
    'inference\solve.py'
    # input
    "--benchmarks $dir/data/stackoverflow/4_collected/stackoverflowFiltered.json"
    "--input.kind $kind"
    '--input.which AllButOne'
    # solver
    "--solver $sol"
    "--solver.implicit $implicit"
    "--solver.iterations $iterations"
    "$extraArgs"
    # model
    "--model.name $model"
    '--cache auto'
    "--cache-root $dir/caches/solve"
    # output
    '--output auto'
    "--output-root $dir/results"
    # debug
    $debugArg
) -join ' '

if ($write) {
    Write-Host $cmd
}
else {
    Invoke-Expression $cmd
}