from pathlib import Path

from redacted import Message, Role
from pydantic import JsonValue
from rich.padding import Padding
from rich.table import Table
from rich.style import Style
import pandas as pd

from settings import Settings


def count_values(v: JsonValue) -> int:
    if isinstance(v, list):
        return sum(count_values(i) for i in v)
    if isinstance(v, dict):
        return sum(count_values(i) for i in v.values())
    return 1


def get_root() -> Path:
    cur = Path(__file__)
    prv = cur
    while not (cur / "setup.ps1").exists():
        cur = cur.parent
        if cur == prv:
            break
    return cur


def render_message(message: Message) -> None:
    if message.content is None:
        return
    role = {
        Role.User: "👤",
        Role.Assistant: "🤖",
        Role.System: "⚙️",
        Role.Tool: "⛏️",
    }
    Settings.console.print(
        f"> {role[message.role]}  {message.role.value.capitalize()}:"
    )
    Settings.console.print(Padding.indent(message.content, 2), highlight=False)


def render_table(df: pd.DataFrame) -> None:
    table = Table()
    table.add_column("metric@k", style=Style(bold=True))
    for h in df.columns:
        table.add_column(h)
    for r in df.itertuples(index=True):
        table.add_row(*map(str, r))
    Settings.console.print(table)
