configurations = \
{0: [{'base_model_name': "WAE",
      'dataset_name': "MNIST",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'WAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'MNIST',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 3e-2,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

 1: [{'base_model_name': "std_vae",
      'dataset_name': "MNIST",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'VAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'MNIST',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.312,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'constant_sigma': None,
                                            'n_components': 10},],

 2: [{'base_model_name': "std_vae",
      'dataset_name': "MNIST",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  '/is/cluster/work/pghosh/high_res_vae/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'CV-VAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'MNIST',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.0195*2,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'constant_sigma': 0.7,
                                            'n_components': 10},],

 3: [{'base_model_name': "RAE",
      'dataset_name': "MNIST",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                            {'expt_name': 'RAE-GP',
                                             'num_filters': 128,
                                             'recon_loss_type': 'l2',
                                             'spec_norm_on_dec_only': False,
                                             'model_name': 'MNIST',
                                             'bottleneck_factor': 16,
                                             'gen_reg_type': ['grad_pen'],
                                             'gen_reg_weight': [0.5e-7],
                                             'embedding_weight': 1e-4,
                                             'pretrained_mdl_path': None,
                                             'include_batch_norm': True,
                                             'n_components': 10},],

 4: [{'base_model_name': "RAE",
      'dataset_name': "MNIST",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE-L2',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'MNIST',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [1e-7],
                                            'embedding_weight': 1e-4,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

 5: [{'base_model_name': "RAE",
      'dataset_name': "MNIST",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'RAE-SN',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'MNIST',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['spec_norm'],
                                            'gen_reg_weight': [None],
                                            'embedding_weight': 0.009,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

 6: [{'base_model_name': "RAE",
      'dataset_name': "MNIST",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'MNIST',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.5e-3,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

 7: [{'base_model_name': "RAE",
      'dataset_name': "MNIST",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'AE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'MNIST',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++ MNIST FINISHED ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#

########################################################## CIFAR_10 #################################################################
 8: [{'base_model_name': "WAE",
      'dataset_name': "CIFAR_10",
      'batch_size': 100,
      'epochs': 200,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'WAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CIFAR',
                                            'bottleneck_factor': 32,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 3e-2,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

 9: [{'base_model_name': "std_vae",
      'dataset_name': "CIFAR_10",
      'batch_size': 100,
      'epochs': 200,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'VAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CIFAR',
                                            'bottleneck_factor': 32,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'constant_sigma': None,
                                            'embedding_weight': 0.024,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,  # N(0, I) FID: 106
                                            'n_components': 10},],

10: [{'base_model_name': "std_vae",
      'dataset_name': "CIFAR_10",
      'batch_size': 200,
      'epochs': 70,
      'log_root':  '/is/cluster/work/pghosh/high_res_vae/logs',
      'log_fid_with_smpls': 1000,
      'num_last_epoch_fid_samples': 10000},
                                          {'expt_name': 'CV-VAE',
                                           'recon_loss_type': 'l2',
                                           'spec_norm_on_dec_only': False,
                                           'model_name': 'CIFAR',
                                           'kernel_size': None,
                                           'num_filters': 128,
                                           'bottleneck_factor': 32,
                                           'gen_reg_type': ['l2'],
                                           'gen_reg_weight': [0],
                                           'embedding_weight': 9e-4,
                                           'cycle_emb_loss_weight': None,
                                           'pretrained_mdl_path': None,
                                           'include_batch_norm': True,
                                           'n_components': 10,
                                           'constant_sigma': 0.7},],

11: [{'base_model_name': "RAE",
      'dataset_name': "CIFAR_10",
      'batch_size': 100,
      'epochs': 200,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                          {'expt_name': 'RAE-GP',
                                           'recon_loss_type': 'l2',
                                           'spec_norm_on_dec_only': False,
                                           'model_name': 'CIFAR',
                                           'kernel_size': None,
                                           'num_filters': 128,
                                           'bottleneck_factor': 32,
                                           'gen_reg_type': ['grad_pen'],
                                           'gen_reg_weight': [0.5e-7],#[0],
                                           'embedding_weight': 1e-4,#9e-4,
                                           'cycle_emb_loss_weight': None,
                                           'pretrained_mdl_path': None,
                                           'include_batch_norm': True,
                                           'n_components': 10,
                                           'constant_sigma': 0.7},],

12: [{'base_model_name': "RAE",
      'dataset_name': "CIFAR_10",
      'batch_size': 100,
      'epochs': 200,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE-L2',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CIFAR',
                                            'bottleneck_factor': 32,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [1e-7],
                                            'embedding_weight': 1e-4,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
					    'n_components': 10},],

13: [{'base_model_name': "RAE",
      'dataset_name': "CIFAR_10",
      'batch_size': 100,
      'epochs': 200,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'RAE-SN',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CIFAR',
                                            'bottleneck_factor': 32,
                                            'gen_reg_type': ['spec_norm'],
                                            'gen_reg_weight': [None],
                                            'embedding_weight': 0.009,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
					    'n_components': 10},],

14: [{'base_model_name': "RAE",
      'dataset_name': "CIFAR_10",
      'batch_size': 100,
      'epochs': 200,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CIFAR',
                                            'bottleneck_factor': 32,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.5e-3,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
					                        'n_components': 10},],

15: [{'base_model_name': "RAE",
      'dataset_name': "CIFAR_10",
      'batch_size': 100,
      'epochs': 200,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'AE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CIFAR',
                                            'bottleneck_factor': 32,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True, 
					                        'n_components': 10},],
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++ CIFAR_10 FINISHED +++++++++++++++++++++++++++++++++++++++++++++++++++++++++#
######################################################## CELEBA #####################################################################
16: [{'base_model_name': "WAE",
      'dataset_name': "CELEBA",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'WAE',
                                            'recon_loss_type': None,
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CELEBA_WAE_PAPER_MAN_EMB_SZIE',
                                            'kernel_size': 5,
                                            'num_filters': 128,
                                            'bottleneck_factor': 64,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 100,
                                            'cycle_emb_loss_weight': None,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

17: [{'base_model_name': "std_vae",
      'dataset_name': "CELEBA",
      'batch_size': 1000,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'VAE',
                                            'recon_loss_type': 'l2',
                                            'num_filters': 128,
                                            'spec_norm_on_dec_only': None,
                                            'model_name': 'CELEBA_WAE_PAPER_MAN_EMB_SZIE',
                                            'bottleneck_factor': 64,
                                            'gen_reg_type': ['grad_pen'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.09024,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'constant_sigma': None,
                                            'n_components': 10},],

18: [{'base_model_name': "std_vae",
      'dataset_name': "CELEBA",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},

                                           {'expt_name': 'CV-VAE',
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CELEBA_WAE_PAPER_MAN_EMB_SZIE',
                                            'kernel_size': None,
                                            'num_filters': 64,
                                            'bottleneck_factor': 64,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.01,
                                            'cycle_emb_loss_weight': None,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 1,
                                            'constant_sigma' : 0.7,},],

19: [{'base_model_name': "RAE",
      'dataset_name': "CELEBA",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},

                                           {'expt_name': 'RAE-GP',
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CELEBA_WAE_PAPER_MAN_EMB_SZIE',
                                            'kernel_size': None,
                                            'num_filters': 128,
                                            'bottleneck_factor': 64,
                                            'gen_reg_type': ['grad_pen'],
                                            'gen_reg_weight': [1e-7],
                                            'embedding_weight': 1e-4,
                                            'cycle_emb_loss_weight': None,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

20: [{'base_model_name': "RAE",
      'dataset_name': "CELEBA",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},

                                           {'expt_name': 'RAE-L2',
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CELEBA_WAE_PAPER_MAN_EMB_SZIE',
                                            'kernel_size': None,
                                            'num_filters': 128,
                                            'bottleneck_factor': 64,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [1e-7],
                                            'embedding_weight': 1e-4,
                                            'cycle_emb_loss_weight': None,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

21: [{'base_model_name': "RAE",
      'dataset_name': "CELEBA",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},

                                           {'expt_name': 'RAE-SN',
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CELEBA_WAE_PAPER_MAN_EMB_SZIE',
                                            'kernel_size': None,
                                            'num_filters': 128,
                                            'bottleneck_factor': 64,
                                            'gen_reg_type': ['spec_norm'],
                                            'gen_reg_weight': [None],
                                            'embedding_weight': 2.4e-3,
                                            'cycle_emb_loss_weight': None,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

22: [{'base_model_name': "RAE",
      'dataset_name': "CELEBA",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},

                                           {'expt_name': 'RAE',
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CELEBA_WAE_PAPER_MAN_EMB_SZIE',
                                            'kernel_size': None,
                                            'num_filters': 128,
                                            'bottleneck_factor': 64,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 1e-4,
                                            'cycle_emb_loss_weight': None,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

23: [{'base_model_name': "RAE",
      'dataset_name': "CELEBA",
      'batch_size': 100,
      'epochs': 70,
      'log_root':  '/is/cluster/work/pghosh/high_res_vae/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},

                                           {'expt_name': 'AE',
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'CELEBA_WAE_PAPER_MAN_EMB_SZIE',
                                            'kernel_size': None,
                                            'num_filters': 128,
                                            'bottleneck_factor': 64,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0,
                                            'cycle_emb_loss_weight': None,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],
#++++++++++++++++++++++++++++++++++++++++++++++ CELEBA FINISHED +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#
########################################################## SVNH #################################################################


 24: [{'base_model_name': "WAE",
      'dataset_name': "SVHN",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'WAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'SVHN',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.006,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

 25: [{'base_model_name': "std_vae",
      'dataset_name': "SVHN",
      'batch_size': 100,
      'epochs': 500,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'VAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'SVHN',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'constant_sigma': None,
                                            'embedding_weight': 0.001,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

26: [{'base_model_name': "std_vae",
      'dataset_name': "SVHN",
      'batch_size': 100,
      'epochs': 70,
      'log_root':  '/is/cluster/work/pghosh/high_res_vae/logs',
      'log_fid_with_smpls': 1000,
      'num_last_epoch_fid_samples': 10000},
                                          {'expt_name': 'CV-VAE',
                                           'recon_loss_type': 'l2',
                                           'spec_norm_on_dec_only': False,
                                           'model_name': 'SVHN',
                                           'kernel_size': None,
                                           'num_filters': 128,
                                           'bottleneck_factor': 16,
                                           'gen_reg_type': ['l2'],
                                           'gen_reg_weight': [0],
                                           'embedding_weight': 9e-4,
                                           'cycle_emb_loss_weight': None,
                                           'pretrained_mdl_path': None,
                                           'include_batch_norm': True,
                                           'n_components': 10,
                                           'constant_sigma': 0.7},],

27: [{'base_model_name': "RAE",
      'dataset_name': "SVHN",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                          {'expt_name': 'RAE-GP',
                                             'num_filters': 128,
                                             'recon_loss_type': 'l2',
                                             'spec_norm_on_dec_only': False,
                                             'model_name': 'SVHN',
                                             'bottleneck_factor': 16,
                                             'gen_reg_type': ['grad_pen'],
                                             'gen_reg_weight': [0.5e-7],
                                             'embedding_weight': 1e-4,
                                             'pretrained_mdl_path': None,
                                             'include_batch_norm': True,
                                             'n_components': 10},],

28: [{'base_model_name': "RAE",
      'dataset_name': "SVHN",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE-L2',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'SVHN',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [1e-7],
                                            'embedding_weight': 1e-4,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

29: [{'base_model_name': "RAE",
      'dataset_name': "SVHN",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'RAE-SN',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'SVHN',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['spec_norm'],
                                            'gen_reg_weight': [None],
                                            'embedding_weight': 0.009,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

30: [{'base_model_name': "RAE",
      'dataset_name': "SVHN",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'SVHN',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.5e-3,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

31: [{'base_model_name': "RAE",
      'dataset_name': "SVHN",
      'batch_size': 100,
      'epochs': 100,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'AE',
                                            'num_filters': 128,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'SVHN',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
					                        'n_components': 10},],
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++ SVNH FINISHED +++++++++++++++++++++++++++++++++++++++++++++++++++++++++#
32: [{'base_model_name': "WAE",
      'dataset_name': "OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'WAE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 3e-2,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

33: [{'base_model_name': "std_vae",
      'dataset_name': "OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'VAE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.312,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'constant_sigma': None,
                                            'n_components': 10},],

34: [{'base_model_name': "std_vae",
      'dataset_name': "OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  '/is/cluster/work/pghosh/high_res_vae/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'CV-VAE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.0195*2,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'constant_sigma': 0.7,
                                            'n_components': 10},],

35: [{'base_model_name': "RAE",
      'dataset_name': "OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                            {'expt_name': 'RAE-GP',
                                             'num_filters': 64,
                                             'recon_loss_type': 'l2',
                                             'spec_norm_on_dec_only': False,
                                             'model_name': 'OASIS',
                                             'bottleneck_factor': 16,
                                             'gen_reg_type': ['grad_pen'],
                                             'gen_reg_weight': [0.5e-7],
                                             'embedding_weight': 1e-4,
                                             'pretrained_mdl_path': None,
                                             'include_batch_norm': True,
                                             'n_components': 10},],

36: [{'base_model_name': "RAE",
      'dataset_name': "OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE-L2',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [1e-7],
                                            'embedding_weight': 1e-4,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

37: [{'base_model_name': "RAE",
      'dataset_name': "OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'RAE-SN',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['spec_norm'],
                                            'gen_reg_weight': [None],
                                            'embedding_weight': 0.009,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

38: [{'base_model_name': "RAE",
      'dataset_name': "OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.5e-3,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

39: [{'base_model_name': "RAE",
      'dataset_name': "OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'AE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True, 
                                            'n_components': 10},],

################################################### Augmentation OASIS ################################################################
40: [{'base_model_name': "WAE",
      'dataset_name': "Augmentation_OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'WAE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 3e-2,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

41: [{'base_model_name': "std_vae",
      'dataset_name': "Augmentation_OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'VAE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.312,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'constant_sigma': None,
                                            'n_components': 10},],

42: [{'base_model_name': "std_vae",
      'dataset_name': "Augmentation_OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  '/is/cluster/work/pghosh/high_res_vae/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'CV-VAE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.0195*2,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'constant_sigma': 0.7,
                                            'n_components': 10},],

43: [{'base_model_name': "RAE",
      'dataset_name': "Augmentation_OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                            {'expt_name': 'RAE-GP',
                                             'num_filters': 64,
                                             'recon_loss_type': 'l2',
                                             'spec_norm_on_dec_only': False,
                                             'model_name': 'OASIS',
                                             'bottleneck_factor': 16,
                                             'gen_reg_type': ['grad_pen'],
                                             'gen_reg_weight': [0.5e-7],
                                             'embedding_weight': 1e-4,
                                             'pretrained_mdl_path': None,
                                             'include_batch_norm': True,
                                             'n_components': 10},],

44: [{'base_model_name': "RAE",
      'dataset_name': "Augmentation_OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE-L2',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [1e-7],
                                            'embedding_weight': 1e-4,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

45: [{'base_model_name': "RAE",
      'dataset_name': "Augmentation_OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},
                                           {'expt_name': 'RAE-SN',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['spec_norm'],
                                            'gen_reg_weight': [None],
                                            'embedding_weight': 0.009,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

46: [{'base_model_name': "RAE",
      'dataset_name': "Augmentation_OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'RAE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0.5e-3,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},],

47: [{'base_model_name': "RAE",
      'dataset_name': "Augmentation_OASIS",
      'batch_size': 100,
      'epochs': 1000,
      'log_root':  'peers/logs',
      'log_fid_with_smpls': 0,
      'num_last_epoch_fid_samples': 10000},  # Use None of 0 to avoid FID computation
                                           {'expt_name': 'AE',
                                            'num_filters': 64,
                                            'recon_loss_type': 'l2',
                                            'spec_norm_on_dec_only': False,
                                            'model_name': 'OASIS',
                                            'bottleneck_factor': 16,
                                            'gen_reg_type': ['l2'],
                                            'gen_reg_weight': [0],
                                            'embedding_weight': 0,
                                            'pretrained_mdl_path': None,
                                            'include_batch_norm': True,
                                            'n_components': 10},]
}
