import os
from imageio import imwrite
import numpy as np


def save_set_of_images(path, images):
    if not os.path.exists(path):
        os.mkdir(path)

    if images.shape[-1]==1:
        images = np.repeat(images, repeats=3, axis=-1)

    images = (np.clip(images, 0, 1) * 255).astype('uint8')
    print(images.shape)

    for i, img in enumerate(images):
        imwrite(os.path.join(path, '%08d.png' % i), img)