repos=('pallets/flask' 'pylint-dev/pylint' 'psf/requests' 'django/django' 'astropy/astropy' 'matplotlib/matplotlib' 'pytest-dev/pytest' 'mwaskom/seaborn' 'sphinx-doc/sphinx' 'sympy/sympy' 'pydata/xarray' 'scikit-learn/scikit-learn')
model='swe7b-oracle-nucleus'
filename='swe_prs_clean-s2-oracle__codellama--CodeLlama-7b-Python-hf_bsz32_lr6e-4_epochs4_warmup0.1_swe_prs_clean.ps-style-2__tok-LlamaTokenizer__po-0__fs-oracle__max_length-30000__checkpoint-best__decode-nucleus'

for item in "${repos[@]}"
do
    IFS='/' read -r -a parts <<< $item
    python instances_eval.py \
        ".//predictions/$model/cleaned_${parts[0]}__${parts[1]}_$filename.jsonl" \
        ".//data/logs/gens/$model" \
        --temp_dir ".//temp/$model/${parts[1]}" \
        --setup_refs_path ".//data/swe-bench-setup-refs.json" \
        --num_workers 1 \
        --timeout 900 \
        --verbose

    echo "Done!"
done