
close all; clear all


%%
angle = [35 80]; 
mI = 41;
xx = linspace(1,2,mI);
yy = linspace(-1,0,mI);
[ma,mb] = meshgrid(xx,yy);
vx = 2+2*sin(xx*2);
vy = 0.2*sqrt((1:length(yy))*4);
ran = cos((ma.*vx+mb.*vy)*4)+sin((ma.*vx-mb.*vy)'*4);
ran = ((ran-1).*(exp(-((xx-0.5).^2+(yy'-1).^2)/5)));
f = ran(:);
D = 2;
tobemax = 1;
[y_optiTrue,x_optiTrue] = max(ran(:));
beta = 2;


%%
Nstart = 30; 
obs = 50;   
seedr = 2;
rng(seedr)
x = [];
for d = 1:Nstart
    x = [x; [xx(randi(length(xx))), yy(randi(length(yy)))]];
end
xdSpace = cell(D,1);
xdSpace{1} = xx;
xdSpace{2} = yy;
Xdfine = cell(D,1);
xallfine = [];
[Xdfine{1:D}] = ndgrid(xdSpace{1:D});
for d = 1:D
    xallfine = [xallfine, Xdfine{d}(:)];
end
y_true = zeros(size(x,1),1);
for t = 1:Nstart
    [~,irow] = ismember(x(t,:), xallfine, 'rows');
    y_true(t) = f(irow); 
end
Fest = [];
AFvalue = [];

if tobemax
    [val,pos] = max(y_true(:)); 
    Fest = [Fest, abs(y_optiTrue-val)];
else
    [val,pos] = min(y_true(:)); 
    Fest = [Fest, abs(y_optiTrue-val)];
end

for j = 1:obs
    
    mdl = fitrgp(x,y_true,'KernelFunction','ardmatern32');
    [y_pred,sd] = predict(mdl,xallfine);
    if tobemax
        UCB = y_pred + beta*sd;
    else
        UCB = -(y_pred - beta*sd);
    end
    [AFmax,posAF] = max(UCB); 
    xAF = xallfine(posAF,:);
    AFvalue = [AFvalue, AFmax];    
    x(end+1,:) = xAF;
    [~,irow] = ismember(x(end,:), xallfine, 'rows');
    y_true(end+1) = f(irow);
   
    if tobemax
        [val,pos] = max(y_true(:)); 
        Fest = [Fest, abs(y_optiTrue-val)];
    else
        [val,pos] = min(y_true(:)); 
        Fest = [Fest, abs(y_optiTrue-val)];
    end
    
end

if tobemax 
        [ao,bo] = max(y_true); 
        str = 'Maximum';
else       
        [ao,bo] = min(y_true);
        str = 'Minimum';
end
fprintf('Bayesian Optimization\n');
fprintf('  %s (estimated):\n\ty(%.6f,%.6f) = %.6f\n',...
    str,x(bo,1),x(bo,2),ao);
fprintf('  %s (true function):\n\ty(%.6f,%.6f) = %.6f\n',...
    str,xallfine(x_optiTrue,1),xallfine(x_optiTrue,2),y_optiTrue);



%%

figure;
subplot(1,3,1)
plot(0:obs, Fest, 'linewidth', 1.3);
xlabel('No. of iterations'); 
ylabel('$|f^{\star}-\hat{f^{\star}}|$','Interpreter','latex');
grid on
title(['GP-UCB'])
xlim([0,obs])


subplot(1,3,2)
surf(Xdfine{1},Xdfine{2},reshape(y_pred,size(Xdfine{1})));
shading interp; 
hold on; view(angle);
scatter3(x(:,1),x(:,2),y_true,10,'g','filled',...
    'MarkerEdgeColor','k');                  
title(sprintf('No. of observed points: %d',length(x)));


subplot(1,3,3)
surf(Xdfine{1},Xdfine{2},reshape(UCB,size(Xdfine{1})));
shading interp; 
hold on; view(angle);
scatter3(x(end,1),x(end,2),AFvalue(end),17,'g','filled',...
    'MarkerEdgeColor','k');                
title(['acf, beta=',num2str(beta)]);






