
function [Theta_return,SigmaV_return,Qvt_retuen,Lvt_return,cholLV_return,likeliLa_retuen] = hyperMatern(ranges, theta_est, hyperN, likeliLa, ...
    tau, Hyv, HHv, min_hp, max_hp, hpri, xx, ddd, R)
min_ls = min_hp(hyperN);
max_ls = max_hp(hyperN);
prior_fn = @(theta) -1/2* hpri(hyperN,2) *(theta-hpri(hyperN,1))^2;
tempt = ranges(hyperN)*rand;
tmin = max(theta_est(hyperN)-tempt, min_ls);
tmax = min(tmin+ranges(hyperN), max_ls);
priorThe = prior_fn(exp(theta_est(hyperN)));
PV = likeliLa + priorThe;
u = rand;
theta_update = theta_est;
while (1)    
    Theta_next = tmin + (tmax-tmin)*rand;
    priorTheNext = prior_fn(exp(Theta_next));    
    theta_update(hyperN) = Theta_next;
    SigmaV_next = covMatern(ddd, [theta_update(1); theta_update(2)], xx);
    [Qvt, Lvt] = eig(SigmaV_next);   
    LambdaVd = cell(1,R);   
    for r = 1:R       
        LambdaVd{r} = tau*HHv{r} + Qvt*diag(1./diag(Lvt))*Qvt';
    end    
    LambdaV = blkdiag(LambdaVd{1:R});
    try
        cholLV = chol(LambdaV);
    catch
        [Ve,dd] = eig(LambdaV);
        dd = diag(dd); dd(dd<1e-10) = 1e-10;
        temp = Ve*diag(dd)*Ve';
        cholLV = chol(temp);
    end
    uu = cholLV'\(cell2mat(Hyv(1:R)'));
    temp1 = 0.5*tau^2*(uu'*uu);
    temp2 = -sum(log(diag(cholLV)))-0.5*R*sum(log(diag(Lvt)));
    likeliLaNext = temp1 + temp2;  
    PV_next = likeliLaNext + priorTheNext;
    if exp(PV_next-PV)>u
        Theta_return = Theta_next;
        SigmaV_return = SigmaV_next;
        Qvt_retuen = Qvt;
        Lvt_return = Lvt;
        cholLV_return = cholLV;
        likeliLa_retuen = likeliLaNext;
        break
    elseif Theta_next<theta_est(hyperN)
        tmin = Theta_next;
    else
        tmax = Theta_next;
    end
end



