ARCH=wo_resi
ATTN=clearclip
STD=5
outputs="./output/tlhclip"
for BENCHMARK in context60 coco_object # voc21 context60 coco_object voc20 city_scapes context59 ade20k coco_stuff164k  
do
  printf "\n${BENCHMARK}, Arch: ${ARCH}, Attn: ${ATTN}, std: ${STD} \n\n" >> ${FILENAME}
  python -m torch.distributed.launch --nproc_per_node=8 --master_port=23455 eval.py --config ./configs/cfg_${BENCHMARK}.py \
            --arch ${ARCH} \
            --attn ${ATTN} \
            --std ${STD} \
            --work-dir ${outputs}/${BENCHMARK} \
            --launcher pytorch 
done
output_file=$(realpath "$outputs/results.txt")
> "$output_file"

cd $outputs

count=0
total=0

while read logfile; do
    echo "Processing: $logfile" >> "$output_file"
    grep "data_root =" "$logfile" >> "$output_file"
    grep "dataset_type =" "$logfile" >> "$output_file"
    
    miou=$(grep -o "mIoU: [0-9.]*" "$logfile" | awk '{print $2}')
    echo "mIoU: $miou" >> "$output_file"
    
    if [[ -n "$miou" ]]; then
        total=$(echo "$total + $miou" | bc)
        count=$((count + 1))
    fi

    echo "" >> "$output_file"
done < <(find . -type f -name "*.log")

echo "Count: $count" >> "$output_file"
echo "Total: $total" >> "$output_file"

if [[ $count -gt 0 ]]; then
    avg=$(echo "scale=4; $total / $count" | bc)
    echo "Average mIoU: $avg" >> "$output_file"
else
    echo "No mIoU values found." >> "$output_file"
fi
