#!/bin/sh -x
PARTITION=h100 #l40s or h100
SIMULATION_IDENTIFIER=sweep_toy_noise
PYTHON_MAIN=sweep_toy_noise.py
# SCRATCH_HOME=/scratch/YOURUSERNAME # I omit this, because it is defined in an environment variable set in my initrc. 
PYTHON_SCRIPT_FLAGS="\
--Nrep 1 --d_min 5 --d_max 8 --save sims.pickle --no_TQDM --no_W_K --abs_eigs \
"
#setting up the sweep parameters. These may overwrite the commands issued above.
PYTHON_SCRIPT_FLAGS+=" \
--replicate_min 0 --replicate_max 50 --replicate_Nstep 50 \
"
export PYTHON_SCRIPT_FLAGS

#compute over a slurm job array
ARRAY_MIN=0
ARRAY_MAX=49
MAXTIME="0-0:20:00"
MAXMEM="80G"
MAXCPU=4
GROUP_DATA_DIRECTORY=/work/YOURGROUPNAME/data
SCRIPTS_FOLDER=slurm_scripts
SUB_SCRIPT=${SCRIPTS_FOLDER}/run_sweep.sh 
# POSTPROCESS_SCRIPT=run_scripts/run_sweep_copy_data.sh

DATA_DIRECTORY=data/${SIMULATION_IDENTIFIER}
SLURMOUT_DIR=${DATA_DIRECTORY}/slurmout_${SIMULATION_IDENTIFIER}
WD_NAME=${SIMULATION_IDENTIFIER}_wd
QUEUE_SCRIPT=$(realpath "$0")

#I want to store the data for this simulation on the work directory, so we create a symlink to the data directory.
mkdir -p ${GROUP_DATA_DIRECTORY}
ln -s -f ${GROUP_DATA_DIRECTORY}
mkdir -p ${DATA_DIRECTORY}
mkdir -p ${DATA_DIRECTORY}/${SCRIPTS_FOLDER}
mkdir -p $SLURMOUT_DIR

#copying all input files to the output directory, for full(er) reproducibility.
cp -r dklib ${DATA_DIRECTORY}/
cp *.py ${DATA_DIRECTORY}/
cp ${SUB_SCRIPT} ${DATA_DIRECTORY}/${SCRIPTS_FOLDER}/
cp ${QUEUE_SCRIPT} ${DATA_DIRECTORY}/${SCRIPTS_FOLDER}/
# cp ${POSTPROCESS_SCRIPT} ${DATA_DIRECTORY}/${SCRIPTS_FOLDER}/


#making the working directory: 
SCRATCH_WORKING_DIRECTORY=${SCRATCH_HOME}/${WD_NAME}
mkdir -p ${SCRATCH_WORKING_DIRECTORY}

# -q debug \ for the debug queue
MAIN_JOBID=$(sbatch --parsable \
 --array=${ARRAY_MIN}-${ARRAY_MAX} \
 -o ${SLURMOUT_DIR}/slurm-%A_%a.out \
 --time=${MAXTIME} \
 --mem=${MAXMEM} \
 -G 1 \
 --cpus-per-task ${MAXCPU} \
 -p ${PARTITION} \
 --job-name=${SIMULATION_IDENTIFIER} \
 --export=DATA_DIRECTORY=${DATA_DIRECTORY},\
SCRATCH_WORKING_DIRECTORY=${SCRATCH_WORKING_DIRECTORY},\
PYTHON_MAIN=${PYTHON_MAIN},\
TQDM_DISABLE=1,\
PYTHON_SCRIPT_FLAGS \
 $SUB_SCRIPT )
echo "Main job id: $MAIN_JOBID"
