#!/bin/bash
#SBATCH --nodes 1
#SBATCH --ntasks 1
#SBATCH --gpus-per-node=1


source ~/.bashrc
conda activate llama_nlp

START_DIR="$PWD"
echo Start directory: $START_DIR
echo Output directory: $DATA_DIRECTORY
echo Base scratch working directory: ${SCRATCH_WORKING_DIRECTORY}

#Setting up the slurm worker directory. 
REPNO_PADDED=$(printf %04d ${SLURM_ARRAY_TASK_ID})
WORKER_DIRECTORY=${SCRATCH_WORKING_DIRECTORY}/${REPNO_PADDED}
mkdir -p $WORKER_DIRECTORY
LOGFILE=${WORKER_DIRECTORY}/${REPNO_PADDED}.log
echo worker directory: $WORKER_DIRECTORY
echo logfile: $LOGFILE
echo Python script flags: ${PYTHON_SCRIPT_FLAGS}

export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK
python $PYTHON_MAIN \
    --job_index ${SLURM_ARRAY_TASK_ID} \
    --N_jobs ${SLURM_ARRAY_TASK_COUNT} \
    --output_path_prefix ${WORKER_DIRECTORY}/ \
    ${PYTHON_SCRIPT_FLAGS} \
    | tee ${LOGFILE}
cp -r ${WORKER_DIRECTORY} ${DATA_DIRECTORY}/