# Graph data valuation

## Installation

To set up the environment and run the project, follow these steps:

### 1. Install PyTorch

Depending on your platform (CPU or GPU), install PyTorch by following the instructions from the official [PyTorch installation guide](https://pytorch.org/get-started/locally/). Here's a basic installation example for CPU:

```bash
pip install torch torchvision torchaudio
```

### 2. Install PyTorch Geometric
To install PyTorch Geometric, follow the installation instructions based on your PyTorch version. Here's a typical installation for the latest version of PyTorch:

```bash
pip install pyg_lib torch-scatter torch-sparse torch-cluster torch-spline-conv torch-geometric
```

### 3. Install the Project Dependencies
Next, install the project dependencies and set up the package in editable mode by running the following command from the root of your project:

```bash
pip install -e .
```

## Usage

Datasets and folders to save the results will be created automatically. Results will be shows in the `storage` folder.

### 1. Compute the node values

For computing the subsets and their respective utility:
```bash
python src/graphsmodel/scripts/train_subsets.py train/model=sgc train.n_models=1 dataset=cora_ml data.alpha=0.1 task=node_level experiment=datamodel 
```

For computing data shapley:
```bash
python src/graphsmodel/scripts/train_subsets.py train/model=sgc train.n_models=1 dataset=cora_ml task=node_level experiment=shapley 
```

For computing pc-winter:
```bash
python src/graphsmodel/scripts/train_subsets.py train/model=sgc train.n_models=1 dataset=cora_ml  task=node_level group_trunc_ratio_hop_1=0.99 group_trunc_ratio_hop_2=0.99 experiment=pc_winter
```

For computing loo:
```bash
python src/graphsmodel/scripts/train_subsets.py train/model=sgc train.n_models=1 dataset=cora_ml  task=node_level experiment=loo
```

#### Experiments

Datamodels will be trained automatically from the previously saved subsets and utilities.

For running node influence experiment
```bash
python src/graphsmodel/scripts/run_node_influence.py train/model=sgc train.n_models=1 dataset=cora_ml data.alpha=0.1 task=node_level train_signal_value=True
```

For brittleness experiment
```bash
python src/graphsmodel/scripts/run_supports.py train/model=sgctrain.n_models=1 dataset=cora_ml data.alpha=0.1 task=node_level
```

For LDS
```bash
python src/graphsmodel/scripts/subsets_influence_corr.py train/model=sgc train.n_models=1 dataset=cora_ml data.alpha=0.1 task=node_level
```

For poisoning
```bash
python src/graphsmodel/scripts/run_memorization.py train/model=sgc train.n_models=1 dataset=cora_ml data.alpha=0.1 task=node_level +high_degree=True +high_logits=False
```

