from pathlib import Path


def decode_path(path):
    path = Path(path)
    path.mkdir(parents=True, exist_ok=True)
    return path


def replace(input_str: str, to_replace: str, replace_with: str) -> str:
    return input_str.replace(to_replace, replace_with)


def get_project_name(project_name, model_target, dataset_name):
    dataset_name = str(dataset_name).replace("-", "_")
    model_name = str(model_target).split(".")[-1]
    return f"{project_name.lower()}_{model_name.lower()}_{dataset_name.lower()}"


def get_results_dir(
    storage_dir,
    dataset_name,
    model_name,
    data_seed,
    subsets_seed,
    subset_mode,
    task_induced_subgraph,
):
    dataset_name = str(dataset_name).replace("-", "_")
    model_name = str(model_name).split(".")[-1]

    results_dir = (
        storage_dir
        / model_name.lower()
        / f"{dataset_name.lower()}_seed_{data_seed}"
        / (f"subsets_seed_{subsets_seed}" if subsets_seed is not None else "")
        / f"{'induced' if task_induced_subgraph else 'unlabeled'}"
        / subset_mode
    )

    # Remove any empty path segments (in case the condition was False)
    results_dir = Path(*filter(None, results_dir.parts))
    results_dir.mkdir(parents=True, exist_ok=True)

    return results_dir


# def get_results_dir(cfg: Any) -> str:
#     """Determines the experiment name based on configuration settings."""
#     node_level = "graph_level" not in cfg.train
#     experiment_name = "loo"
#     if node_level:
#         is_induced = "induced" if cfg.train.induced_subgraph else "unlabelled"
#         experiment_name += f"-{is_induced}"
#     return experiment_name
