# export BASTIONSUB="46da6261-2167-4e71-8b0d-f4a45215ce61"
# az account set --subscription $BASTIONSUB

# Set your DOMAIN and username here. Make sure DOMAIN is uppercase for example REDMOND.jsmith
export USERNAME=DOMAIN.username

# Set the host you wish to connect to here which is going to be your reserved Linux or Windows GPU dev nodes you reserved via gcr-reservation portal
export SANDBOXNAME='GCRAZGDL0001'

# Set the type of sandbox:
# for GPU
export SANDBOXTYPE="GPU"

# for CPU
export SANDBOXTYPE="CPU"

# Created based on your input above
export SANDBOXRG="${SANDBOXTYPE}-SANDBOX"
export BASTIONNAME="${SANDBOXRG}-VNET-bastion"

# EXCEPTION: If your sandbox name is GCRAZGDL1XXXX AND your region is "North Central"
export SANDBOXRG="GPU-SANDBOX2"
export BASTIONNAME="${SANDBOXRG}-VNET-bastion"

sudo az network bastion tunnel --name $BASTIONNAME --resource-group $SANDBOXRG --target-resource-id /subscriptions/${BASTIONSUB}/resourceGroups/${SANDBOXRG}/providers/Microsoft.Compute/virtualMachines/${SANDBOXNAME} --resource-port 22 --port 22222