#! /bin/bash

export SCRIPT_DIR="$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"
export PROJECT_DIR="$( cd -- "$( dirname -- "$SCRIPT_DIR" )" &> /dev/null && pwd )"
cd $PROJECT_DIR
export PYTHONPATH="$PYTHONPATH:$PROJECT_DIR"
export LIBTPU_INIT_ARGS="--xla_tpu_megacore_fusion_allow_ags=false --xla_enable_async_collective_permute=true --xla_tpu_enable_ag_backward_pipelining=true --xla_tpu_enable_data_parallel_all_reduce_opt=true --xla_tpu_data_parallel_opt_different_sized_ops=true --xla_tpu_enable_async_collective_fusion=true --xla_tpu_enable_async_collective_fusion_multiple_steps=true --xla_tpu_overlap_compute_collective_tc=true --xla_enable_async_all_gather=true"

export llama_tokenizer_path="llava/checkpoints/lwm_checkpoints/tokenizer.model"
export dataset_path="data/cross_attn_nsvq_code256_layer8_seq1_whole_train.jsonl"
export eval_dataset_path="data/cross_attn_nsvq_code256_layer8_seq1_whole_validation.jsonl"

export output_dir="llava/checkpoints/debug"

export project_id='lwm'
export experiment_note='world-model'
export experiment_id='example-vision-text-train_7b_pad_10epoch_whole_2e5_1024batch'

# mesh_dim: dp, fsdp, tp, sp
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python3 -u -m lwm.train \
    --modality='vision,text' \
    --mesh_dim='!-1,8,1,1' \
    --dtype='bf16' \
    --total_steps=4557 \
    --log_freq=1 \
    --delta_tokens=1 \
    --eval_steps=1 \
    --save_model_freq=0 \
    --eval_log_freq=100 \
    --save_milestone_freq=900 \
    --load_llama_config='7b' \
    --load_checkpoint="params::/home/World-Model/llava/checkpoints/lwm_checkpoints/params"\
    --update_llama_config="dict(delta_vocab_size=32,theta=50000000,max_sequence_length=2048,use_flash_attention=True,scan_attention=True,scan_query_chunk_size=512,scan_key_chunk_size=1024,remat_attention='nothing_saveable',scan_mlp=True,scan_mlp_chunk_size=8192,remat_mlp='nothing_saveable',remat_block='nothing_saveable',scan_layers=True)" \
    --tokenizer.vocab_file="$llama_tokenizer_path" \
    --optimizer.type='adamw' \
    --llama.delta_vocab_size=32 \
    --optimizer.accumulate_gradient_steps=1 \
    --optimizer.adamw_optimizer.weight_decay=0.1 \
    --optimizer.adamw_optimizer.lr=2e-5 \
    --optimizer.adamw_optimizer.end_lr=2e-5\
    --optimizer.adamw_optimizer.lr_warmup_steps=40 \
    --optimizer.adamw_optimizer.lr_decay_steps=4557 \
    --use_data_sharded_loader=True \
    --train_dataset.type='json_vision_delta' \
    --train_dataset.delta_vision_text_processor.fields_from_example='fields' \
    --train_dataset.delta_vision_text_processor.n_tokens_per_delta=1 \
    --train_dataset.delta_vision_text_processor.max_n_frames=1 \
    --train_dataset.json_delta_dataset.mode="pad" \
    --train_dataset.json_delta_dataset.path="$dataset_path" \
    --train_dataset.json_delta_dataset.seq_length=384 \
    --train_dataset.json_delta_dataset.batch_size=1024 \
    --train_dataset.json_delta_dataset.tokenizer_processes=1 \
    --train_dataset.json_delta_dataset.tokenizer_parallel_chunk_size=1024 \
    --train_dataset.json_delta_dataset.tokenizer_parallel_batch_size=1024 \
    --train_dataset.json_delta_dataset.use_data_sharded_loader=True \
    --eval_dataset.type='json_vision_delta' \
    --eval_dataset.delta_vision_text_processor.fields_from_example='fields' \
    --eval_dataset.delta_vision_text_processor.n_tokens_per_delta=1 \
    --eval_dataset.delta_vision_text_processor.max_n_frames=1 \
    --eval_dataset.json_delta_dataset.mode="pad" \
    --eval_dataset.json_delta_dataset.path="$eval_dataset_path" \
    --eval_dataset.json_delta_dataset.seq_length=384 \
    --eval_dataset.json_delta_dataset.batch_size=1024 \
    --eval_dataset.json_delta_dataset.tokenizer_processes=1 \
    --eval_dataset.json_delta_dataset.tokenizer_parallel_chunk_size=1024 \
    --eval_dataset.json_delta_dataset.tokenizer_parallel_batch_size=1024 \
    --eval_dataset.json_delta_dataset.use_data_sharded_loader=True \
    --checkpointer.save_optimizer_state=True \
    --autoresume=False \
    --logger.append_uuid=False \
    --logger.online=False \
    --logger.project_entity="lklab_kaist"\
    --logger.project_id="$project_id" \
    --logger.experiment_id="$experiment_id" \
    --logger.experiment_note="$experiment_note" \
    --logger.output_dir="$output_dir" \
    --logger.wandb_dir="$HOME/experiment_output/$project_id"
